package com.temboo.Library.Microsoft.Translator;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetToken

Retrieves an access token that can be used to authenticate with the Microsoft Translator API.
*/
public class GetToken extends Choreography {

	/**
	Create a new instance of the GetToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/Translator/GetToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTokenInputSet
	*/
	public GetTokenInputSet newInputSet() {
		return new GetTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTokenInputSet extends InputSet {
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTokenResultSet extends ResultSet {
		public GetTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (string) The access token returned from Microsoft.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "ExpiresIn" output from this Choreo execution

		@return String - (integer) The number of seconds for which the access token is valid.
		*/
		public String get_ExpiresIn() {
			return this.getResultString("ExpiresIn");
		}
	}
	
}
