package com.temboo.Library.FedEx.TrackingAndVisibility;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TrackByReference

Retrieves shipment information for a specified reference number.
*/
public class TrackByReference extends Choreography {

	/**
	Create a new instance of the TrackByReference Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TrackByReference(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FedEx/TrackingAndVisibility/TrackByReference"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TrackByReferenceInputSet
	*/
	public TrackByReferenceInputSet newInputSet() {
		return new TrackByReferenceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TrackByReferenceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TrackByReferenceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TrackByReference
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TrackByReferenceInputSet extends InputSet {
		/** 
		Set the value of the AccountNumber input for this Choreo. 

		@param String - (required, string) Your FedEx Account Number or Test Account Number.
		*/
		public void set_AccountNumber(String value) {
			this.setInput("AccountNumber", value);
		}


		/** 
		Set the value of the AuthenticationKey input for this Choreo. 

		@param String - (required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
		*/
		public void set_AuthenticationKey(String value) {
			this.setInput("AuthenticationKey", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The destination city.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (conditional, string) The country code associated with the shipment destination (e.g., US). Required unless specifying the ShipmentAccountNumber.
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MeterNumber input for this Choreo. 

		@param String - (required, string) The Production or Test Meter Number provided by FedEx Web Services.
		*/
		public void set_MeterNumber(String value) {
			this.setInput("MeterNumber", value);
		}


		/** 
		Set the value of the OperatingCompany input for this Choreo. 

		@param String - (required, string) Identification for a fedex operating company (e.g.,  fedex_express, fedex_freight, fedex_ground). See Choreo notes for allowed values.
		*/
		public void set_OperatingCompany(String value) {
			this.setInput("OperatingCompany", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Production or Test Password provided by FedEx Web Services.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PostalCode input for this Choreo. 

		@param String - (conditional, string) The postal code associated with the shipment destination. Required unless specifying the ShipmentAccountNumber.
		*/
		public void set_PostalCode(String value) {
			this.setInput("PostalCode", value);
		}


		/** 
		Set the value of the Reference input for this Choreo. 

		@param String - (required, string) A reference number for tracking the shipment.
		*/
		public void set_Reference(String value) {
			this.setInput("Reference", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ShipDateRangeBegin input for this Choreo. 

		@param String - (optional, date) Specifies the beginning of a date range used to narrow the search to a period in time. Dates should be formatted as YYYY-MM-DD.
		*/
		public void set_ShipDateRangeBegin(String value) {
			this.setInput("ShipDateRangeBegin", value);
		}


		/** 
		Set the value of the ShipDateRangeEnd input for this Choreo. 

		@param String - (optional, date) Specifies the beginning of a date range used to narrow the search to a period in time. Dates should be formatted as YYYY-MM-DD.
		*/
		public void set_ShipDateRangeEnd(String value) {
			this.setInput("ShipDateRangeEnd", value);
		}


		/** 
		Set the value of the ShipmentAccountNumber input for this Choreo. 

		@param String - (conditional, string) The shipment account number. Required unless specifying the PostalCode and CountryCode.
		*/
		public void set_ShipmentAccountNumber(String value) {
			this.setInput("ShipmentAccountNumber", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Identifying abbreviation for US state, Canada province of the shipment destination (e.g., NY).
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Street input for this Choreo. 

		@param String - (optional, string) The street number and street name for the shipment destination (e.g., 350 5th Ave).
		*/
		public void set_Street(String value) {
			this.setInput("Street", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TrackByReference Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TrackByReferenceResultSet extends ResultSet {
		public TrackByReferenceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from FedEx.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
