package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetSessionID

Generates an authorization URL that an application can use to complete the first step in the authentication process.
*/
public class GetSessionID extends Choreography {

	/**
	Create a new instance of the GetSessionID Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetSessionID(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/GetSessionID"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetSessionIDInputSet
	*/
	public GetSessionIDInputSet newInputSet() {
		return new GetSessionIDInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetSessionIDResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetSessionIDResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetSessionID
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetSessionIDInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The unique identifier for the application.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the CertID input for this Choreo. 

		@param String - (required, string) The certificate that authenticates the application when making API calls.
		*/
		public void set_CertID(String value) {
			this.setInput("CertID", value);
		}


		/** 
		Set the value of the DevID input for this Choreo. 

		@param String - (required, string) The unique identifier for the developer's account.
		*/
		public void set_DevID(String value) {
			this.setInput("DevID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the RuName input for this Choreo. 

		@param String - (required, string) Your application's RuName which identifies your application to eBay.
		*/
		public void set_RuName(String value) {
			this.setInput("RuName", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetSessionID Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetSessionIDResultSet extends ResultSet {
		public GetSessionIDResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AuthorizationURL" output from this Choreo execution

		@return String - (string) The URL that you can send the user to so that they can sign-in and approve the user consent form.
		*/
		public String get_AuthorizationURL() {
			return this.getResultString("AuthorizationURL");
		}
		/** 
		Retrieve the value for the "SessionID" output from this Choreo execution

		@return String - (string) The SessionID returned from eBay. This gets passed to the FetchToken Choreo after the user authorizes the request.
		*/
		public String get_SessionID() {
			return this.getResultString("SessionID");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
