package com.temboo.Library.Utilities.Validation;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
EmailAddress

Verifies that a given email address matches an expected standard pattern.
*/
public class EmailAddress extends Choreography {

	/**
	Create a new instance of the EmailAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public EmailAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Validation/EmailAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return EmailAddressInputSet
	*/
	public EmailAddressInputSet newInputSet() {
		return new EmailAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public EmailAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new EmailAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the EmailAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class EmailAddressInputSet extends InputSet {
		/** 
		Set the value of the EmailAddress input for this Choreo. 

		@param String - (required, string) The email address to validate.
		*/
		public void set_EmailAddress(String value) {
			this.setInput("EmailAddress", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the EmailAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class EmailAddressResultSet extends ResultSet {
		public EmailAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Match" output from this Choreo execution

		@return String - (string) Contains a string indicating the result of the match -- "valid" or "invalid".
		*/
		public String get_Match() {
			return this.getResultString("Match");
		}
	}
	
}
