package com.temboo.Library.Utilities.Encoding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Base64Decode

Returns the specified Base64 encoded string as decoded text.
*/
public class Base64Decode extends Choreography {

	/**
	Create a new instance of the Base64Decode Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Base64Decode(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Encoding/Base64Decode"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return Base64DecodeInputSet
	*/
	public Base64DecodeInputSet newInputSet() {
		return new Base64DecodeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public Base64DecodeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new Base64DecodeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Base64Decode
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class Base64DecodeInputSet extends InputSet {
		/** 
		Set the value of the Base64EncodedText input for this Choreo. 

		@param String - (required, string) The Base64 encoded text to decode. Note that Base64 encoded binary data is not allowed.
		*/
		public void set_Base64EncodedText(String value) {
			this.setInput("Base64EncodedText", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Base64Decode Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class Base64DecodeResultSet extends ResultSet {
		public Base64DecodeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Text" output from this Choreo execution

		@return String - (string) The decoded text.
		*/
		public String get_Text() {
			return this.getResultString("Text");
		}
	}
	
}
