package com.temboo.Library.FedEx.TrackingAndVisibility;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TrackByNumber

Retrieves shipment information for a specified tracking number.
*/
public class TrackByNumber extends Choreography {

	/**
	Create a new instance of the TrackByNumber Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TrackByNumber(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FedEx/TrackingAndVisibility/TrackByNumber"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TrackByNumberInputSet
	*/
	public TrackByNumberInputSet newInputSet() {
		return new TrackByNumberInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TrackByNumberResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TrackByNumberResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TrackByNumber
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TrackByNumberInputSet extends InputSet {
		/** 
		Set the value of the AccountNumber input for this Choreo. 

		@param String - (required, string) Your FedEx Account Number or Test Account Number.
		*/
		public void set_AccountNumber(String value) {
			this.setInput("AccountNumber", value);
		}


		/** 
		Set the value of the AuthenticationKey input for this Choreo. 

		@param String - (required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
		*/
		public void set_AuthenticationKey(String value) {
			this.setInput("AuthenticationKey", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MeterNumber input for this Choreo. 

		@param String - (required, string) The Production or Test Meter Number provided by FedEx Web Services.
		*/
		public void set_MeterNumber(String value) {
			this.setInput("MeterNumber", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Production or Test Password provided by FedEx Web Services.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TrackingNumber input for this Choreo. 

		@param String - (required, string) The tracking number for the shipment.
		*/
		public void set_TrackingNumber(String value) {
			this.setInput("TrackingNumber", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TrackByNumber Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TrackByNumberResultSet extends ResultSet {
		public TrackByNumberResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from FedEx.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
