package com.temboo.Library.SunlightLabs.Congress.District;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetDistrictsByCoordinates

Returns the district that a set of latitude/longitude coordinates falls within.
*/
public class GetDistrictsByCoordinates extends Choreography {

	/**
	Create a new instance of the GetDistrictsByCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetDistrictsByCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SunlightLabs/Congress/District/GetDistrictsByCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetDistrictsByCoordinatesInputSet
	*/
	public GetDistrictsByCoordinatesInputSet newInputSet() {
		return new GetDistrictsByCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetDistrictsByCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetDistrictsByCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetDistrictsByCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetDistrictsByCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Sunlight Labs.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude coordinate of the area that a legislator represents.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude coordinate of the area that a legislator represents.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate of the area that a legislator represents.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate of the area that a legislator represents.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetDistrictsByCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetDistrictsByCoordinatesResultSet extends ResultSet {
		public GetDistrictsByCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the Sunlight Congress API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
