package com.temboo.Library.Withings.Measure;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetBodyMetrics

Retrieves body metrics for the specified user.
*/
public class GetBodyMetrics extends Choreography {

	/**
	Create a new instance of the GetBodyMetrics Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetBodyMetrics(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Withings/Measure/GetBodyMetrics"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetBodyMetricsInputSet
	*/
	public GetBodyMetricsInputSet newInputSet() {
		return new GetBodyMetricsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetBodyMetricsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetBodyMetricsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetBodyMetrics
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetBodyMetricsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the Category input for this Choreo. 

		@param Integer - (optional, integer) Set to 2 to retrieve objectives or to 1 to retrieve actual measurements.
		*/
		public void set_Category(Integer value) {
			this.setInput("Category", value);
		}

		/** 
		Set the value of the Category input for this Choreo as a String. 

		@param String - (optional, integer) Set to 2 to retrieve objectives or to 1 to retrieve actual measurements.
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);	
		}
		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Withings.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Withings.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the DeviceType input for this Choreo. 

		@param Integer - (optional, integer) Retrieves data for a particular device type. Specifying 1 will retrieve all body scale related measures and 0 will retrieve all user personal data entered at user creation time.
		*/
		public void set_DeviceType(Integer value) {
			this.setInput("DeviceType", value);
		}

		/** 
		Set the value of the DeviceType input for this Choreo as a String. 

		@param String - (optional, integer) Retrieves data for a particular device type. Specifying 1 will retrieve all body scale related measures and 0 will retrieve all user personal data entered at user creation time.
		*/
		public void set_DeviceType(String value) {
			this.setInput("DeviceType", value);	
		}
		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (optional, date) Retrieves results dated before the specified EPOCH formatted date.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the LastUpdated input for this Choreo. 

		@param String - (optional, date) Retrieves results added or modified since the specified EPOCH formatted date.
		*/
		public void set_LastUpdated(String value) {
			this.setInput("LastUpdated", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Limits the number of measure groups returned in the result.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Limits the number of measure groups returned in the result.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the MeasurementType input for this Choreo. 

		@param Integer - (optional, integer) Filters by the measurement type. Set to 1 to filter by weight or 4 to filter by height.
		*/
		public void set_MeasurementType(Integer value) {
			this.setInput("MeasurementType", value);
		}

		/** 
		Set the value of the MeasurementType input for this Choreo as a String. 

		@param String - (optional, integer) Filters by the measurement type. Set to 1 to filter by weight or 4 to filter by height.
		*/
		public void set_MeasurementType(String value) {
			this.setInput("MeasurementType", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) Used in combination with the Limit parameter to page through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) Used in combination with the Limit parameter to page through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, date) Retrieves results dated after the specified EPOCH formatted date.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (required, string) The ID of the user to retrieve body metrics for.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetBodyMetrics Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetBodyMetricsResultSet extends ResultSet {
		public GetBodyMetricsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Withings.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
