package com.temboo.Library.Xively.ReadWriteData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
WriteData

Allows you to update your feed, including updating/creating new datastreams and datapoints. 
*/
public class WriteData extends Choreography {

	/**
	Create a new instance of the WriteData Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public WriteData(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/ReadWriteData/WriteData"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return WriteDataInputSet
	*/
	public WriteDataInputSet newInputSet() {
		return new WriteDataInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public WriteDataResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new WriteDataResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the WriteData
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class WriteDataInputSet extends InputSet {
		/** 
		Set the value of the FeedData input for this Choreo. 

		@param String - (optional, any) Custom data body for the new feed in JSON or XML format (set by FeedType).  See Xively documentation (link below) for the minimum required fields. If FeedData is used, Value and Timestamp are ignored.
		*/
		public void set_FeedData(String value) {
			this.setInput("FeedData", value);
		}


		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the DatastreamID input for this Choreo. 

		@param String - (optional, string) ID for single datastream you would like to update. Required if specifying a single datapoint update using Value.
		*/
		public void set_DatastreamID(String value) {
			this.setInput("DatastreamID", value);
		}


		/** 
		Set the value of the FeedID input for this Choreo. 

		@param Integer - (required, integer) The ID for the feed that you would like to update.
		*/
		public void set_FeedID(Integer value) {
			this.setInput("FeedID", value);
		}

		/** 
		Set the value of the FeedID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the feed that you would like to update.
		*/
		public void set_FeedID(String value) {
			this.setInput("FeedID", value);	
		}
		/** 
		Set the value of the FeedType input for this Choreo. 

		@param String - (optional, string) The type of feed that is being provided for custom FeedData. Valid values are "json" (the default), "xml" and "csv". Ignored if specifying single datapoint Value.
		*/
		public void set_FeedType(String value) {
			this.setInput("FeedType", value);
		}


		/** 
		Set the value of the Timestamp input for this Choreo. 

		@param String - (optional, date) Can be used with a single Value and DatastreamID. If specified, sets timestamp for Value. If Value is set with blank Timestamp, Value's timestamp will be current time. Ex: 2013-05-10T00:00:00.123456Z.
		*/
		public void set_Timestamp(String value) {
			this.setInput("Timestamp", value);
		}


		/** 
		Set the value of the Value input for this Choreo. 

		@param String - (optional, string) Specifies the value for a single datapoint in a specified datastream.
		*/
		public void set_Value(String value) {
			this.setInput("Value", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the WriteData Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class WriteDataResultSet extends ResultSet {
		public WriteDataResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Xively. For a successful feed / data update, the code should be 200.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
	}
	
}
