package com.temboo.Library.Xively.Products;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateProduct

Updates an existing product batch.
*/
public class UpdateProduct extends Choreography {

	/**
	Create a new instance of the UpdateProduct Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateProduct(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/Products/UpdateProduct"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateProductInputSet
	*/
	public UpdateProductInputSet newInputSet() {
		return new UpdateProductInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateProductResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateProductResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateProduct
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateProductInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CustomProduct input for this Choreo. 

		@param String - (optional, json) Optional custom configuration for creating your product in JSON. If you use this field the other optional parameters will be ignored. See Choreo description and Xively documentation for details.
		*/
		public void set_CustomProduct(String value) {
			this.setInput("CustomProduct", value);
		}


		/** 
		Set the value of the Datastreams input for this Choreo. 

		@param String - (optional, json) Default device datastream JSON array. Every newly created device in this product will have this default datastream. Ex: [{"id":"channel1"},{"id":"demo"}].
		*/
		public void set_Datastreams(String value) {
			this.setInput("Datastreams", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) Description of the product.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (optional, string) Name of the product.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Private input for this Choreo. 

		@param String - (optional, string) Default device feed privacy settings. Valid values: "true", "false" (default). Note - leaving this blank will automatically change a private device feed to a public device feed.
		*/
		public void set_Private(String value) {
			this.setInput("Private", value);
		}


		/** 
		Set the value of the ProductID input for this Choreo. 

		@param String - (required, string) The ID of the product you are trying to update.
		*/
		public void set_ProductID(String value) {
			this.setInput("ProductID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateProduct Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateProductResultSet extends ResultSet {
		public UpdateProductResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Xively. For a successful product update, the code should be 200.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
	}
	
}
