package com.temboo.Library.Stripe.Events;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
MoneyReceived

Retrieves a list of successful charge events.
*/
public class MoneyReceived extends Choreography {

	/**
	Create a new instance of the MoneyReceived Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public MoneyReceived(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/Events/MoneyReceived"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return MoneyReceivedInputSet
	*/
	public MoneyReceivedInputSet newInputSet() {
		return new MoneyReceivedInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public MoneyReceivedResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new MoneyReceivedResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the MoneyReceived
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class MoneyReceivedInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Stripe
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (optional, integer) A limit on the number of events to be returned. Count can range between 1 and 100 items. Defaults to 10.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, integer) A limit on the number of events to be returned. Count can range between 1 and 100 items. Defaults to 10.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the Created input for this Choreo. 

		@param String - (optional, date) Filters the result based on the event created date (a UTC timestamp).
		*/
		public void set_Created(String value) {
			this.setInput("Created", value);
		}


		/** 
		Set the value of the GreaterThan input for this Choreo. 

		@param String - (optional, date) Returns events that have been created after this UTC timestamp.
		*/
		public void set_GreaterThan(String value) {
			this.setInput("GreaterThan", value);
		}


		/** 
		Set the value of the GreaterThanEqualTo input for this Choreo. 

		@param String - (optional, date) Returns events that have been created after or equal to this UTC timestamp.
		*/
		public void set_GreaterThanEqualTo(String value) {
			this.setInput("GreaterThanEqualTo", value);
		}


		/** 
		Set the value of the LessThan input for this Choreo. 

		@param String - (optional, date) Return events that were created before this UTC timestamp.
		*/
		public void set_LessThan(String value) {
			this.setInput("LessThan", value);
		}


		/** 
		Set the value of the LessThanEqualTo input for this Choreo. 

		@param String - (optional, date) Return events that were created before or equal to this UTC timestamp.
		*/
		public void set_LessThanEqualTo(String value) {
			this.setInput("LessThanEqualTo", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) An offset into your events array. The API will return the requested number of events starting at that offset.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) An offset into your events array. The API will return the requested number of events starting at that offset.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the ResponseMode input for this Choreo. 

		@param String - (optional, string) Used to simplify the response. Valid values are: simple and verbose. When set to simple, an array of charge amounts is returned. Verbose mode returns an array of charge objects. Defaults to "simple".
		*/
		public void set_ResponseMode(String value) {
			this.setInput("ResponseMode", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the MoneyReceived Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class MoneyReceivedResultSet extends ResultSet {
		public MoneyReceivedResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "TotalCount" output from this Choreo execution

		@return String - (integer) The total number of results. This can be used to determine whether or not you need to retrieve the next page of results.
		*/
		public String get_TotalCount() {
			return this.getResultString("TotalCount");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Stripe
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
