package com.temboo.Library.Amazon.SQS;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetQueueAttributes

Retrieves one or all attributes of a queue.
*/
public class GetQueueAttributes extends Choreography {

	/**
	Create a new instance of the GetQueueAttributes Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetQueueAttributes(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/SQS/GetQueueAttributes"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetQueueAttributesInputSet
	*/
	public GetQueueAttributesInputSet newInputSet() {
		return new GetQueueAttributesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetQueueAttributesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetQueueAttributesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetQueueAttributes
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetQueueAttributesInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSAccountId input for this Choreo. 

		@param Integer - (required, integer) The AWS account number of the queue owner. Enter account number omitting any dashes.
		*/
		public void set_AWSAccountId(Integer value) {
			this.setInput("AWSAccountId", value);
		}

		/** 
		Set the value of the AWSAccountId input for this Choreo as a String. 

		@param String - (required, integer) The AWS account number of the queue owner. Enter account number omitting any dashes.
		*/
		public void set_AWSAccountId(String value) {
			this.setInput("AWSAccountId", value);	
		}
		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AttributeName input for this Choreo. 

		@param String - (optional, string) The name of the attribute that you want to retrieve for the specified queue. Defaults to 'All'.
		*/
		public void set_AttributeName(String value) {
			this.setInput("AttributeName", value);
		}


		/** 
		Set the value of the QueueName input for this Choreo. 

		@param String - (required, string) The name of the queue to retrieve attributes for.
		*/
		public void set_QueueName(String value) {
			this.setInput("QueueName", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the SQS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetQueueAttributes Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetQueueAttributesResultSet extends ResultSet {
		public GetQueueAttributesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
