package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutObjectACL

Sets the access control list (ACL) permissions for an existing object.
*/
public class PutObjectACL extends Choreography {

	/**
	Create a new instance of the PutObjectACL Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutObjectACL(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/PutObjectACL"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutObjectACLInputSet
	*/
	public PutObjectACLInputSet newInputSet() {
		return new PutObjectACLInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutObjectACLResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutObjectACLResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutObjectACL
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutObjectACLInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AccessControlList input for this Choreo. 

		@param String - (optional, xml) Custom Access Control List xml for advanced configuration. See description for an example, plus Amazon documentation.
		*/
		public void set_AccessControlList(String value) {
			this.setInput("AccessControlList", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that contains the object that you want to create or update a policy for.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the CannedACL input for this Choreo. 

		@param String - (conditional, string) Most common ACL usage, required unless creating a custom policy. Values: private, public-read, public-read-write, authenticated-read, bucket-owner-read, or bucket-owner-full-control.
		*/
		public void set_CannedACL(String value) {
			this.setInput("CannedACL", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The name of the file or object that you want to put access controls on in S3. Ex.: file.txt or folder/file.txt.
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the OwnerEmailAddress input for this Choreo. 

		@param String - (optional, string) The email address of the owner who is granting permission. Required if creating your own custom ACL policy.
		*/
		public void set_OwnerEmailAddress(String value) {
			this.setInput("OwnerEmailAddress", value);
		}


		/** 
		Set the value of the OwnerId input for this Choreo. 

		@param String - (optional, string) The canonical user id of the owner who is granting permission. Required if creating your own custom ACL policy.
		*/
		public void set_OwnerId(String value) {
			this.setInput("OwnerId", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutObjectACL Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutObjectACLResultSet extends ResultSet {
		public PutObjectACLResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Stores the response from Amazon. Note that for a successful ACL creation, no content is returned and this output variable is empty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
