package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutObject

Uploads a file to your Amazon S3 storage bucket.
*/
public class PutObject extends Choreography {

	/**
	Create a new instance of the PutObject Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutObject(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/PutObject"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutObjectInputSet
	*/
	public PutObjectInputSet newInputSet() {
		return new PutObjectInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutObjectResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutObjectResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutObject
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutObjectInputSet extends InputSet {
		/** 
		Set the value of the FileContents input for this Choreo. 

		@param String - (required, string) The Base64-encoded file contents that you want to upload to an AmazonS3 bucket. This is required unless providing a URL to a hosted file to upload, using the UploadSourceURL input.
		*/
		public void set_FileContents(String value) {
			this.setInput("FileContents", value);
		}


		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that will be the file destination.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the CannedACL input for this Choreo. 

		@param String - (optional, string) By default all objects are private (only owner has full access control). Valid values: private, public-read, public-read-write, authenticated-read, bucket-owner-read, bucket-owner-full-control.
		*/
		public void set_CannedACL(String value) {
			this.setInput("CannedACL", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) Sets the content-type (text/html, image/jpeg, etc.). Default is application/octet-stream.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The name of the file to put in S3 Storage. Ex.: file.txt or folder/file.txt
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the SSECAlgorithm input for this Choreo. 

		@param String - (optional, string) Specifies the server-side encryption with customer-provided encryption keys (SSE-C) algorithm to use when Amazon S3 creates the target object. Valid value: AES256.
		*/
		public void set_SSECAlgorithm(String value) {
			this.setInput("SSECAlgorithm", value);
		}


		/** 
		Set the value of the SSECKey input for this Choreo. 

		@param String - (optional, string) The customer-provided AES-256 256-bit (32-byte) encryption key for Amazon S3 to use to encrypt or decrypt your data.
		*/
		public void set_SSECKey(String value) {
			this.setInput("SSECKey", value);
		}


		/** 
		Set the value of the ServerSideEncryption input for this Choreo. 

		@param String - (optional, string) Specifies the server-side encryption algorithm to use when Amazon S3 creates the target object. Valid value: AES256.
		*/
		public void set_ServerSideEncryption(String value) {
			this.setInput("ServerSideEncryption", value);
		}


		/** 
		Set the value of the StorageClass input for this Choreo. 

		@param String - (optional, string) Enables RRS customers to store their noncritical, reproducible data at lower levels of redundancy than Amazon S3's standard storage. Valid Values: STANDARD (default), REDUCED_REDUNDANCY.
		*/
		public void set_StorageClass(String value) {
			this.setInput("StorageClass", value);
		}


		/** 
		Set the value of the UploadSourcePassword input for this Choreo. 

		@param String - (optional, string) The password to use when Basic Authentiation is required to access a file located at the URL specified in the UploadSourceURL input.
		*/
		public void set_UploadSourcePassword(String value) {
			this.setInput("UploadSourcePassword", value);
		}


		/** 
		Set the value of the UploadSourceURL input for this Choreo. 

		@param String - (optional, string) A URL to a hosted file that should be uploaded. This is required unless providing a Base64 encoded file for the FileContents input.
		*/
		public void set_UploadSourceURL(String value) {
			this.setInput("UploadSourceURL", value);
		}


		/** 
		Set the value of the UploadSourceUsername input for this Choreo. 

		@param String - (optional, string) The username to use when Basic Authentiation is required to access a file located at the URL specified in the UploadSourceURL input.
		*/
		public void set_UploadSourceUsername(String value) {
			this.setInput("UploadSourceUsername", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (conditional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


		/** 
		Set the value of the WebsiteRedirectLocation input for this Choreo. 

		@param String - (optional, string) If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Ex: /anotherPage.html, http://www.page.com. Max length: 2 K.
		*/
		public void set_WebsiteRedirectLocation(String value) {
			this.setInput("WebsiteRedirectLocation", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - (optional, vault file) The path to a vault file that you want to upload to an Amazon S3 bucket. Required unless using the FileContents input variable.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutObject Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutObjectResultSet extends ResultSet {
		public PutObjectResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon. Note that no content is returned for successful uploads.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
