package com.temboo.Library.Amazon.DynamoDB;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Scan

Returns one or more items and item attributes by accessing every item in a table or a secondary index.
*/
public class Scan extends Choreography {

	/**
	Create a new instance of the Scan Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Scan(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/DynamoDB/Scan"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ScanInputSet
	*/
	public ScanInputSet newInputSet() {
		return new ScanInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ScanResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ScanResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Scan
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ScanInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the ConsistentRead input for this Choreo. 

		@param Boolean - (optional, boolean) A Boolean value that determines the read consistency model during the scan.
		*/
		public void set_ConsistentRead(Boolean value) {
			this.setInput("ConsistentRead", value);
		}

		/** 
		Set the value of the ConsistentRead input for this Choreo as a String. 

		@param String - (optional, boolean) A Boolean value that determines the read consistency model during the scan.
		*/
		public void set_ConsistentRead(String value) {
			this.setInput("ConsistentRead", value);	
		}
		/** 
		Set the value of the ExclusiveStartKey input for this Choreo. 

		@param String - (optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
		*/
		public void set_ExclusiveStartKey(String value) {
			this.setInput("ExclusiveStartKey", value);
		}


		/** 
		Set the value of the ExpressionAttributeNames input for this Choreo. 

		@param String - (optional, json) One or more substitution tokens for attribute names in an expression.
		*/
		public void set_ExpressionAttributeNames(String value) {
			this.setInput("ExpressionAttributeNames", value);
		}


		/** 
		Set the value of the ExpressionAttributeValues input for this Choreo. 

		@param String - (optional, json) One or more values that can be substituted in an expression.
		*/
		public void set_ExpressionAttributeValues(String value) {
			this.setInput("ExpressionAttributeValues", value);
		}


		/** 
		Set the value of the FilterExpression input for this Choreo. 

		@param String - (optional, string) A string that contains conditions that DynamoDB applies after the Scan operation, but before the data is returned to you.
		*/
		public void set_FilterExpression(String value) {
			this.setInput("FilterExpression", value);
		}


		/** 
		Set the value of the IndexName input for this Choreo. 

		@param String - (optional, string) The name of an index to scan. This index can be any local secondary index or global secondary index on the table.
		*/
		public void set_IndexName(String value) {
			this.setInput("IndexName", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ProjectionExpression input for this Choreo. 

		@param String - (optional, string) A string that identifies one or more attributes to retrieve from the table.
		*/
		public void set_ProjectionExpression(String value) {
			this.setInput("ProjectionExpression", value);
		}


		/** 
		Set the value of the ReturnConsumedCapacity input for this Choreo. 

		@param String - (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
		*/
		public void set_ReturnConsumedCapacity(String value) {
			this.setInput("ReturnConsumedCapacity", value);
		}


		/** 
		Set the value of the Segment input for this Choreo. 

		@param Integer - (optional, integer) For a parallel Scan request, Segment identifies an individual segment to be scanned by an application worker.
		*/
		public void set_Segment(Integer value) {
			this.setInput("Segment", value);
		}

		/** 
		Set the value of the Segment input for this Choreo as a String. 

		@param String - (optional, integer) For a parallel Scan request, Segment identifies an individual segment to be scanned by an application worker.
		*/
		public void set_Segment(String value) {
			this.setInput("Segment", value);	
		}
		/** 
		Set the value of the Select input for this Choreo. 

		@param String - (optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.
		*/
		public void set_Select(String value) {
			this.setInput("Select", value);
		}


		/** 
		Set the value of the TableName input for this Choreo. 

		@param String - (required, string) The name of the table containing the requested items.
		*/
		public void set_TableName(String value) {
			this.setInput("TableName", value);
		}


		/** 
		Set the value of the TotalSegments input for this Choreo. 

		@param Integer - (optional, integer) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.
		*/
		public void set_TotalSegments(Integer value) {
			this.setInput("TotalSegments", value);
		}

		/** 
		Set the value of the TotalSegments input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.
		*/
		public void set_TotalSegments(String value) {
			this.setInput("TotalSegments", value);	
		}
		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Scan Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ScanResultSet extends ResultSet {
		public ScanResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
