package com.temboo.Library.Amazon.DynamoDB;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetItem

Returns a set of attributes for the item with the given primary key.
*/
public class GetItem extends Choreography {

	/**
	Create a new instance of the GetItem Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetItem(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/DynamoDB/GetItem"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetItemInputSet
	*/
	public GetItemInputSet newInputSet() {
		return new GetItemInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetItemResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetItemResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetItem
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetItemInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the ConsistentRead input for this Choreo. 

		@param Boolean - (optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
		*/
		public void set_ConsistentRead(Boolean value) {
			this.setInput("ConsistentRead", value);
		}

		/** 
		Set the value of the ConsistentRead input for this Choreo as a String. 

		@param String - (optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
		*/
		public void set_ConsistentRead(String value) {
			this.setInput("ConsistentRead", value);	
		}
		/** 
		Set the value of the ExpressionAttributeNames input for this Choreo. 

		@param String - (optional, json) One or more substitution tokens for attribute names in an expression.
		*/
		public void set_ExpressionAttributeNames(String value) {
			this.setInput("ExpressionAttributeNames", value);
		}


		/** 
		Set the value of the Key input for this Choreo. 

		@param String - (required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.
		*/
		public void set_Key(String value) {
			this.setInput("Key", value);
		}


		/** 
		Set the value of the ProjectionExpression input for this Choreo. 

		@param String - (optional, string) A string that identifies one or more attributes to retrieve from the table.
		*/
		public void set_ProjectionExpression(String value) {
			this.setInput("ProjectionExpression", value);
		}


		/** 
		Set the value of the ReturnConsumedCapacity input for this Choreo. 

		@param String - (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
		*/
		public void set_ReturnConsumedCapacity(String value) {
			this.setInput("ReturnConsumedCapacity", value);
		}


		/** 
		Set the value of the TableName input for this Choreo. 

		@param String - (required, string) The name of the table containing the requested items.
		*/
		public void set_TableName(String value) {
			this.setInput("TableName", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetItem Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetItemResultSet extends ResultSet {
		public GetItemResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
