package com.temboo.Library.PayPal.Merchant;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RefundTransaction

Issue a refund to a PayPal buyer by specifying a transaction ID.
*/
public class RefundTransaction extends Choreography {

	/**
	Create a new instance of the RefundTransaction Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RefundTransaction(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/Merchant/RefundTransaction"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RefundTransactionInputSet
	*/
	public RefundTransactionInputSet newInputSet() {
		return new RefundTransactionInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RefundTransactionResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RefundTransactionResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RefundTransaction
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RefundTransactionInputSet extends InputSet {
		/** 
		Set the value of the Amount input for this Choreo. 

		@param BigDecimal - (optional, decimal) Refund amount. Amount is required if RefundType is set to Partial. If RefundType is set to Full, leave input blank.
		*/
		public void set_Amount(BigDecimal value) {
			this.setInput("Amount", value);
		}

		/** 
		Set the value of the Amount input for this Choreo as a String. 

		@param String - (optional, decimal) Refund amount. Amount is required if RefundType is set to Partial. If RefundType is set to Full, leave input blank.
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);	
		}
		/** 
		Set the value of the CurrencyCode input for this Choreo. 

		@param String - (optional, string) A three-character currency code (i.e. USD). Required for partial refunds. Leave this field blank for full refunds. Defaults to USD.
		*/
		public void set_CurrencyCode(String value) {
			this.setInput("CurrencyCode", value);
		}


		/** 
		Set the value of the InvoiceID input for this Choreo. 

		@param String - (optional, string) Your own invoice or tracking number. Character length limitation is 127 alphanumeric characters.
		*/
		public void set_InvoiceID(String value) {
			this.setInput("InvoiceID", value);
		}


		/** 
		Set the value of the Note input for this Choreo. 

		@param String - (optional, string) Custom note about the refund. Character length limitation is 255 alphanumeric characters.
		*/
		public void set_Note(String value) {
			this.setInput("Note", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The API Password provided by PayPal.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RefundType input for this Choreo. 

		@param String - (required, string) The refund type must be set to Full or Partial.  This flag effects what values some other input variables should have. Defaults to Full.
		*/
		public void set_RefundType(String value) {
			this.setInput("RefundType", value);
		}


		/** 
		Set the value of the Signature input for this Choreo. 

		@param String - (required, string) The API Signature provided by PayPal.
		*/
		public void set_Signature(String value) {
			this.setInput("Signature", value);
		}


		/** 
		Set the value of the TransactionID input for this Choreo. 

		@param String - (required, string) The ID for the transaction you want to retrieve data for.
		*/
		public void set_TransactionID(String value) {
			this.setInput("TransactionID", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The API Username provided by PayPal.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RefundTransaction Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RefundTransactionResultSet extends ResultSet {
		public RefundTransactionResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) Response from PayPal formatted in name/value pairs.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
