package com.temboo.Library.EnviroFacts.Toxins;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ChemicalSearch

Retrieves information about specific chemicals released by EPA-regulated facilities.
*/
public class ChemicalSearch extends Choreography {

	/**
	Create a new instance of the ChemicalSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ChemicalSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/EnviroFacts/Toxins/ChemicalSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ChemicalSearchInputSet
	*/
	public ChemicalSearchInputSet newInputSet() {
		return new ChemicalSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ChemicalSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ChemicalSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ChemicalSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ChemicalSearchInputSet extends InputSet {
		/** 
		Set the value of the ChemicalID input for this Choreo. 

		@param String - (required, string) EPA ID number of a chemical. Chemical IDs from a given facility can be found by first running the ChemActivityByFacility or ToxinReleaseByFacility Choreos.
		*/
		public void set_ChemicalID(String value) {
			this.setInput("ChemicalID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ChemicalSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ChemicalSearchResultSet extends ResultSet {
		public ChemicalSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from EnviroFacts.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
