package com.temboo.Library.Basecamp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ProjectCounts

Retrieves a count of all projects sorted by project status.
*/
public class ProjectCounts extends Choreography {

	/**
	Create a new instance of the ProjectCounts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ProjectCounts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Basecamp/ProjectCounts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ProjectCountsInputSet
	*/
	public ProjectCountsInputSet newInputSet() {
		return new ProjectCountsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ProjectCountsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ProjectCountsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ProjectCounts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ProjectCountsInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) The Basecamp account name for you or your company. This is the first part of your account URL.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Basecamp password.  You can use the value 'X' when specifying an API Key for the Username input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Your Basecamp username or API Key.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ProjectCounts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ProjectCountsResultSet extends ResultSet {
		public ProjectCountsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Basecamp.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
