package com.temboo.Library.Amazon.IAM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateLoginProfile

Creates a password for the specified user, which gives the user the ability to access AWS services through the AWS Management Console.
*/
public class CreateLoginProfile extends Choreography {

	/**
	Create a new instance of the CreateLoginProfile Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateLoginProfile(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/IAM/CreateLoginProfile"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateLoginProfileInputSet
	*/
	public CreateLoginProfileInputSet newInputSet() {
		return new CreateLoginProfileInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateLoginProfileResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateLoginProfileResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateLoginProfile
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateLoginProfileInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the MustChangePassword input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not the user is required to change their password immediately.  Valid values are true/false or 1/0.
		*/
		public void set_MustChangePassword(Boolean value) {
			this.setInput("MustChangePassword", value);
		}

		/** 
		Set the value of the MustChangePassword input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not the user is required to change their password immediately.  Valid values are true/false or 1/0.
		*/
		public void set_MustChangePassword(String value) {
			this.setInput("MustChangePassword", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) The new password for the user.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserName input for this Choreo. 

		@param String - (required, string) The name of the user to create a password for.
		*/
		public void set_UserName(String value) {
			this.setInput("UserName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateLoginProfile Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateLoginProfileResultSet extends ResultSet {
		public CreateLoginProfileResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
