package com.temboo.Library.Mixpanel.Profiles;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Set

Sets the properties of a profile.
*/
public class Set extends Choreography {

	/**
	Create a new instance of the Set Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Set(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Mixpanel/Profiles/Set"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SetInputSet
	*/
	public SetInputSet newInputSet() {
		return new SetInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SetResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SetResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Set
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SetInputSet extends InputSet {
		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The city associated with the user's location.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the Created input for this Choreo. 

		@param String - (optional, date) The time when the user created their account. This should be expressed as YYYY-MM-DDThh:mm:ss.
		*/
		public void set_Created(String value) {
			this.setInput("Created", value);
		}


		/** 
		Set the value of the DistinctID input for this Choreo. 

		@param String - (required, string) Used to uniquely identify the profile you want to update.
		*/
		public void set_DistinctID(String value) {
			this.setInput("DistinctID", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) The user's email address. Mixpanel can use this property when sending email notifications to your users.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (optional, string) The first name of the user represented the profile.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the IP input for this Choreo. 

		@param String - (optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.
		*/
		public void set_IP(String value) {
			this.setInput("IP", value);
		}


		/** 
		Set the value of the IgnoreTime input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.
		*/
		public void set_IgnoreTime(Boolean value) {
			this.setInput("IgnoreTime", value);
		}

		/** 
		Set the value of the IgnoreTime input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.
		*/
		public void set_IgnoreTime(String value) {
			this.setInput("IgnoreTime", value);	
		}
		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (optional, string) The last name of the user representing the profile.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (optional, string) The full name of the user. This can be used as an alternative to FirstName and LastName.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Phone input for this Choreo. 

		@param String - (optional, string) The user's phone number (e.g., 4805551212). Mixpanel can use this property when sending SMS messages to your users.
		*/
		public void set_Phone(String value) {
			this.setInput("Phone", value);
		}


		/** 
		Set the value of the ProfileProperties input for this Choreo. 

		@param String - (optional, json) A JSON object containing names and values of custom profile properties. Note that properties that exist already will be overwritten.
		*/
		public void set_ProfileProperties(String value) {
			this.setInput("ProfileProperties", value);
		}


		/** 
		Set the value of the Region input for this Choreo. 

		@param String - (optional, string) The region associated with a user's location.
		*/
		public void set_Region(String value) {
			this.setInput("Region", value);
		}


		/** 
		Set the value of the Time input for this Choreo. 

		@param String - (optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.
		*/
		public void set_Time(String value) {
			this.setInput("Time", value);
		}


		/** 
		Set the value of the Timezone input for this Choreo. 

		@param String - (optional, string) The timezone associated with a user's location.
		*/
		public void set_Timezone(String value) {
			this.setInput("Timezone", value);
		}


		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


		/** 
		Set the value of the Verbose input for this Choreo. 

		@param Boolean - (optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.
		*/
		public void set_Verbose(Boolean value) {
			this.setInput("Verbose", value);
		}

		/** 
		Set the value of the Verbose input for this Choreo as a String. 

		@param String - (optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.
		*/
		public void set_Verbose(String value) {
			this.setInput("Verbose", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Set Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SetResultSet extends ResultSet {
		public SetResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Mixpanel.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
