package com.temboo.Library.Microsoft.Excel.Table;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListColumns

Retrieve a list of tablecolumn objects.
*/
public class ListColumns extends Choreography {

	/**
	Create a new instance of the ListColumns Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListColumns(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/Excel/Table/ListColumns"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListColumnsInputSet
	*/
	public ListColumnsInputSet newInputSet() {
		return new ListColumnsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListColumnsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListColumnsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListColumns
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListColumnsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ItemPath input for this Choreo. 

		@param String - (required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
		*/
		public void set_ItemPath(String value) {
			this.setInput("ItemPath", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Select input for this Choreo. 

		@param String - (optional, string) Comma-separated list of properties to include in the response.
		*/
		public void set_Select(String value) {
			this.setInput("Select", value);
		}


		/** 
		Set the value of the Skip input for this Choreo. 

		@param Integer - (optional, integer) The number of items to skip in a result set.
		*/
		public void set_Skip(Integer value) {
			this.setInput("Skip", value);
		}

		/** 
		Set the value of the Skip input for this Choreo as a String. 

		@param String - (optional, integer) The number of items to skip in a result set.
		*/
		public void set_Skip(String value) {
			this.setInput("Skip", value);	
		}
		/** 
		Set the value of the Table input for this Choreo. 

		@param String - (required, string) The name or id of the table.
		*/
		public void set_Table(String value) {
			this.setInput("Table", value);
		}


		/** 
		Set the value of the Top input for this Choreo. 

		@param Integer - (optional, integer) The number of items to return in a result set.
		*/
		public void set_Top(Integer value) {
			this.setInput("Top", value);
		}

		/** 
		Set the value of the Top input for this Choreo as a String. 

		@param String - (optional, integer) The number of items to return in a result set.
		*/
		public void set_Top(String value) {
			this.setInput("Top", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the Worksheet input for this Choreo. 

		@param String - (required, string) The name or id of the worksheet.
		*/
		public void set_Worksheet(String value) {
			this.setInput("Worksheet", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListColumns Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListColumnsResultSet extends ResultSet {
		public ListColumnsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Microsoft.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
