package com.temboo.Library.PagerDuty.LogEntries;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLogEntry

Returns details for a specific incident log entry.
*/
public class GetLogEntry extends Choreography {

	/**
	Create a new instance of the GetLogEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLogEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PagerDuty/LogEntries/GetLogEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLogEntryInputSet
	*/
	public GetLogEntryInputSet newInputSet() {
		return new GetLogEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLogEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLogEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLogEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLogEntryInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by PagerDuty.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the LogEntryID input for this Choreo. 

		@param String - (required, string) The ID of the log entry to return.
		*/
		public void set_LogEntryID(String value) {
			this.setInput("LogEntryID", value);
		}


		/** 
		Set the value of the SubDomain input for this Choreo. 

		@param String - (required, string) The subdomain of your PagerDuty site address.
		*/
		public void set_SubDomain(String value) {
			this.setInput("SubDomain", value);
		}


		/** 
		Set the value of the TimeZone input for this Choreo. 

		@param String - (optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
		*/
		public void set_TimeZone(String value) {
			this.setInput("TimeZone", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLogEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLogEntryResultSet extends ResultSet {
		public GetLogEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PagerDuty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
