package com.temboo.Library.USPS.AddressInformationAPI;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ValidateAddress

Validates and supplements incomplete address information.
*/
public class ValidateAddress extends Choreography {

	/**
	Create a new instance of the ValidateAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ValidateAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/USPS/AddressInformationAPI/ValidateAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ValidateAddressInputSet
	*/
	public ValidateAddressInputSet newInputSet() {
		return new ValidateAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ValidateAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ValidateAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ValidateAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ValidateAddressInputSet extends InputSet {
		/** 
		Set the value of the AptOrSuite input for this Choreo. 

		@param String - (optional, string) Used to provide an apartment or suite number, if applicable. Maximum characters allowed: 38.
		*/
		public void set_AptOrSuite(String value) {
			this.setInput("AptOrSuite", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) Maximum characters allowed: 15. Either City and State or Zip are required.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (optional, string) If you are accessing the production server, set to 'production'. Defaults to 'testing' which indicates that you are using the sandbox.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the FirmName input for this Choreo. 

		@param String - (optional, string) Maximum characters allowed: 38.
		*/
		public void set_FirmName(String value) {
			this.setInput("FirmName", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The password assigned by USPS
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Maximum characters allowed: 2. Either City and State or Zip are required.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the StreetAddress input for this Choreo. 

		@param String - (required, string) Street address. Maximum characters allowed: 38.
		*/
		public void set_StreetAddress(String value) {
			this.setInput("StreetAddress", value);
		}


		/** 
		Set the value of the Urbanization input for this Choreo. 

		@param String - (optional, string) Maximum characters allowed: 28. For Puerto Rico addresses only.
		*/
		public void set_Urbanization(String value) {
			this.setInput("Urbanization", value);
		}


		/** 
		Set the value of the UserId input for this Choreo. 

		@param String - (required, string) Alphanumeric ID assigned by USPS
		*/
		public void set_UserId(String value) {
			this.setInput("UserId", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param Integer - (optional, integer) Maximum characters allowed: 5. Either City and State or Zip are required.
		*/
		public void set_Zip(Integer value) {
			this.setInput("Zip", value);
		}

		/** 
		Set the value of the Zip input for this Choreo as a String. 

		@param String - (optional, integer) Maximum characters allowed: 5. Either City and State or Zip are required.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);	
		}
		/** 
		Set the value of the Zip4DigitCode input for this Choreo. 

		@param Integer - (optional, integer) Maximum characters allowed: 4
		*/
		public void set_Zip4DigitCode(Integer value) {
			this.setInput("Zip4DigitCode", value);
		}

		/** 
		Set the value of the Zip4DigitCode input for this Choreo as a String. 

		@param String - (optional, integer) Maximum characters allowed: 4
		*/
		public void set_Zip4DigitCode(String value) {
			this.setInput("Zip4DigitCode", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ValidateAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ValidateAddressResultSet extends ResultSet {
		public ValidateAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from USPS Web Service
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
