package com.temboo.Library.Utilities.Finding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RegexMatch

Returns the first substring that matches the specified regular expression pattern in the specified string.
*/
public class RegexMatch extends Choreography {

	/**
	Create a new instance of the RegexMatch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RegexMatch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Finding/RegexMatch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RegexMatchInputSet
	*/
	public RegexMatchInputSet newInputSet() {
		return new RegexMatchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RegexMatchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RegexMatchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RegexMatch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RegexMatchInputSet extends InputSet {
		/** 
		Set the value of the Pattern input for this Choreo. 

		@param String - (conditional, string) A regular expression.
		*/
		public void set_Pattern(String value) {
			this.setInput("Pattern", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (conditional, string) The text on which to perform a regex match.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RegexMatch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RegexMatchResultSet extends ResultSet {
		public RegexMatchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Result" output from this Choreo execution

		@return String - (string) The result of the match.
		*/
		public String get_Result() {
			return this.getResultString("Result");
		}
	}
	
}
