package com.temboo.Library.Utilities.Callback;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetCallbackData

Retrieves data captured from a request to your callback URL.
*/
public class GetCallbackData extends Choreography {

	/**
	Create a new instance of the GetCallbackData Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetCallbackData(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Callback/GetCallbackData"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCallbackDataInputSet
	*/
	public GetCallbackDataInputSet newInputSet() {
		return new GetCallbackDataInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCallbackDataResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCallbackDataResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetCallbackData
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCallbackDataInputSet extends InputSet {
		/** 
		Set the value of the CallbackID input for this Choreo. 

		@param String - (required, string) The ID that can used to retrieve request data that the callback URL has captured.
		*/
		public void set_CallbackID(String value) {
			this.setInput("CallbackID", value);
		}


		/** 
		Set the value of the FilterName input for this Choreo. 

		@param String - (optional, string) Allows you to filter callback data by a query parameter key-value pair. FilterValue is required when using this input.
		*/
		public void set_FilterName(String value) {
			this.setInput("FilterName", value);
		}


		/** 
		Set the value of the FilterValue input for this Choreo. 

		@param String - (optional, string) Allows you to filter callback data by a query parameter key-value pair. FilterName is required when using this input.
		*/
		public void set_FilterValue(String value) {
			this.setInput("FilterValue", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetCallbackData Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCallbackDataResultSet extends ResultSet {
		public GetCallbackDataResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CallbackData" output from this Choreo execution

		@return String - Contains the request data received at your CalllbackURL.
		*/
		public String get_CallbackData() {
			return this.getResultString("CallbackData");
		}
	}
	
}
