package com.temboo.Library.Zendesk.Requests;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateRequest

Creates a new end-user request.
*/
public class CreateRequest extends Choreography {

	/**
	Create a new instance of the CreateRequest Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateRequest(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Requests/CreateRequest"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateRequestInputSet
	*/
	public CreateRequestInputSet newInputSet() {
		return new CreateRequestInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateRequestResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateRequestResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateRequest
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateRequestInputSet extends InputSet {
		/** 
		Set the value of the RequestData input for this Choreo. 

		@param String - (optional, json) A JSON-formatted string containing the request properties you wish to set. This can be used as an alternative to setting individual inputs representing request properties.
		*/
		public void set_RequestData(String value) {
			this.setInput("RequestData", value);
		}


		/** 
		Set the value of the Comment input for this Choreo. 

		@param String - (conditional, string) A comment associated with the request.
		*/
		public void set_Comment(String value) {
			this.setInput("Comment", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Priority input for this Choreo. 

		@param String - (conditional, string) Priority (e.g. low, normal, high, urgent). Defaults to normal.
		*/
		public void set_Priority(String value) {
			this.setInput("Priority", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Subject input for this Choreo. 

		@param String - (conditional, string) The subject of the request.
		*/
		public void set_Subject(String value) {
			this.setInput("Subject", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (conditional, string) Type of request (e.g.question, incident, problem, task). Defaults to incident.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateRequest Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateRequestResultSet extends ResultSet {
		public CreateRequestResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
