package com.temboo.Library.Basecamp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UncompleteEntry

Marks a specific calendar entry as uncompleted.
*/
public class UncompleteEntry extends Choreography {

	/**
	Create a new instance of the UncompleteEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UncompleteEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Basecamp/UncompleteEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UncompleteEntryInputSet
	*/
	public UncompleteEntryInputSet newInputSet() {
		return new UncompleteEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UncompleteEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UncompleteEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UncompleteEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UncompleteEntryInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) A valid Basecamp account name. This is the first part of the account's URL.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the EntryID input for this Choreo. 

		@param Integer - (required, integer) The ID for the calendar entry to mark as uncompleted.
		*/
		public void set_EntryID(Integer value) {
			this.setInput("EntryID", value);
		}

		/** 
		Set the value of the EntryID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the calendar entry to mark as uncompleted.
		*/
		public void set_EntryID(String value) {
			this.setInput("EntryID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Basecamp account password. Use the value 'X' when specifying an API Key for the Username input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ProjectID input for this Choreo. 

		@param Integer - (required, integer) The ID for the project with the calendar entry to mark as uncompleted.
		*/
		public void set_ProjectID(Integer value) {
			this.setInput("ProjectID", value);
		}

		/** 
		Set the value of the ProjectID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the project with the calendar entry to mark as uncompleted.
		*/
		public void set_ProjectID(String value) {
			this.setInput("ProjectID", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) A Basecamp account username or API Key.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UncompleteEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UncompleteEntryResultSet extends ResultSet {
		public UncompleteEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response returned from Basecamp.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
