package com.temboo.Library.DataGov;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetCensusIDByCoordinates

Retrieve the U.S. census block geography ID for a specified latitude and longitude. 
*/
public class GetCensusIDByCoordinates extends Choreography {

	/**
	Create a new instance of the GetCensusIDByCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetCensusIDByCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DataGov/GetCensusIDByCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCensusIDByCoordinatesInputSet
	*/
	public GetCensusIDByCoordinatesInputSet newInputSet() {
		return new GetCensusIDByCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCensusIDByCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCensusIDByCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetCensusIDByCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCensusIDByCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the GeographyType input for this Choreo. 

		@param String - (required, string) Specify one of the following geography type values: "state", "county", "tract", "block", "congdistrict", "statehouse", "statesenate", "censusplace", or "msa" (metropolitan statistical area).
		*/
		public void set_GeographyType(String value) {
			this.setInput("GeographyType", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Specify a latitude to search for, such as "41.486857".
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) Specify a latitude to search for, such as "41.486857".
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Specify a longitude to search for, such as "-71.294392".
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) Specify a longitude to search for, such as "-71.294392".
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetCensusIDByCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCensusIDByCoordinatesResultSet extends ResultSet {
		public GetCensusIDByCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CensusID" output from this Choreo execution

		@return String - (integer) The ID retrieved from the API call.
		*/
		public String get_CensusID() {
			return this.getResultString("CensusID");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response returned from the API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
