package com.temboo.Library.Utilities.XML;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetValuesFromXML

Returns all element or attribute values with a specified name.
*/
public class GetValuesFromXML extends Choreography {

	/**
	Create a new instance of the GetValuesFromXML Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetValuesFromXML(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/XML/GetValuesFromXML"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetValuesFromXMLInputSet
	*/
	public GetValuesFromXMLInputSet newInputSet() {
		return new GetValuesFromXMLInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetValuesFromXMLResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetValuesFromXMLResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetValuesFromXML
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetValuesFromXMLInputSet extends InputSet {
		/** 
		Set the value of the Node input for this Choreo. 

		@param String - (required, string) The name of the element or attribute that contains the values you want to return. Note that attribute names should be preceded with an "@" sign (e.g. @name).
		*/
		public void set_Node(String value) {
			this.setInput("Node", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json or csv.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the XML input for this Choreo. 

		@param String - (required, xml) The XML that contains the elements or attributes you want to retrieve.
		*/
		public void set_XML(String value) {
			this.setInput("XML", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetValuesFromXML Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetValuesFromXMLResultSet extends ResultSet {
		public GetValuesFromXMLResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Result" output from this Choreo execution

		@return String - The element or attribute values.
		*/
		public String get_Result() {
			return this.getResultString("Result");
		}
	}
	
}
