package com.temboo.Library.Utilities.JSON;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetValuesFromJSON

Searches for the specified property in the supplied JSON string.
*/
public class GetValuesFromJSON extends Choreography {

	/**
	Create a new instance of the GetValuesFromJSON Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetValuesFromJSON(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/JSON/GetValuesFromJSON"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetValuesFromJSONInputSet
	*/
	public GetValuesFromJSONInputSet newInputSet() {
		return new GetValuesFromJSONInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetValuesFromJSONResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetValuesFromJSONResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetValuesFromJSON
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetValuesFromJSONInputSet extends InputSet {
		/** 
		Set the value of the JSON input for this Choreo. 

		@param String - (required, json) JSON String to search.
		*/
		public void set_JSON(String value) {
			this.setInput("JSON", value);
		}


		/** 
		Set the value of the Property input for this Choreo. 

		@param String - (required, string) Property to match in the specified JSON string.
		*/
		public void set_Property(String value) {
			this.setInput("Property", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetValuesFromJSON Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetValuesFromJSONResultSet extends ResultSet {
		public GetValuesFromJSONResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) Value(s) that match the property.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
