package com.temboo.Library.Utilities.HTTP;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Put

Generates a HTTP PUT request.
*/
public class Put extends Choreography {

	/**
	Create a new instance of the Put Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Put(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/HTTP/Put"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutInputSet
	*/
	public PutInputSet newInputSet() {
		return new PutInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Put
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutInputSet extends InputSet {
		/** 
		Set the value of the RequestBody input for this Choreo. 

		@param String - (optional, multiline) The request body for the PUT request.
		*/
		public void set_RequestBody(String value) {
			this.setInput("RequestBody", value);
		}


		/** 
		Set the value of the Debug input for this Choreo. 

		@param Boolean - (optional, boolean) When set to "true", the HTTP debug log will be returned.
		*/
		public void set_Debug(Boolean value) {
			this.setInput("Debug", value);
		}

		/** 
		Set the value of the Debug input for this Choreo as a String. 

		@param String - (optional, boolean) When set to "true", the HTTP debug log will be returned.
		*/
		public void set_Debug(String value) {
			this.setInput("Debug", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) A valid password. This is used if the request required basic authentication.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RequestHeaders input for this Choreo. 

		@param String - (optional, json) A JSON object containing up to 10 key/value pairs that will be mapped to the HTTP request headers.
		*/
		public void set_RequestHeaders(String value) {
			this.setInput("RequestHeaders", value);
		}


		/** 
		Set the value of the RequestParameters input for this Choreo. 

		@param String - (optional, json) A JSON object containing up to 10 key/value pairs that will be mapped to the url string as HTTP parameters.
		*/
		public void set_RequestParameters(String value) {
			this.setInput("RequestParameters", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (required, string) The base URL for the request (including http:// or https://).
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) A valid username. This is used if the request required basic authentication.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Put Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutResultSet extends ResultSet {
		public PutResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "HTTPLog" output from this Choreo execution

		@return String - (string) A debug log for the http request that was sent. This is only returned when Debug is set to "true".
		*/
		public String get_HTTPLog() {
			return this.getResultString("HTTPLog");
		}
		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the server.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
