package com.temboo.Library.Utilities.Dates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTimestamp

Returns the current date and time, expressed as seconds or milliseconds since January 1, 1970 (epoch time).
*/
public class GetTimestamp extends Choreography {

	/**
	Create a new instance of the GetTimestamp Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTimestamp(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Dates/GetTimestamp"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTimestampInputSet
	*/
	public GetTimestampInputSet newInputSet() {
		return new GetTimestampInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTimestampResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTimestampResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTimestamp
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTimestampInputSet extends InputSet {
		/** 
		Set the value of the AddDays input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddDays(Integer value) {
			this.setInput("AddDays", value);
		}

		/** 
		Set the value of the AddDays input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddDays(String value) {
			this.setInput("AddDays", value);	
		}
		/** 
		Set the value of the AddHours input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddHours(Integer value) {
			this.setInput("AddHours", value);
		}

		/** 
		Set the value of the AddHours input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddHours(String value) {
			this.setInput("AddHours", value);	
		}
		/** 
		Set the value of the AddMinutes input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMinutes(Integer value) {
			this.setInput("AddMinutes", value);
		}

		/** 
		Set the value of the AddMinutes input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMinutes(String value) {
			this.setInput("AddMinutes", value);	
		}
		/** 
		Set the value of the AddMonths input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMonths(Integer value) {
			this.setInput("AddMonths", value);
		}

		/** 
		Set the value of the AddMonths input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMonths(String value) {
			this.setInput("AddMonths", value);	
		}
		/** 
		Set the value of the AddSeconds input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddSeconds(Integer value) {
			this.setInput("AddSeconds", value);
		}

		/** 
		Set the value of the AddSeconds input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddSeconds(String value) {
			this.setInput("AddSeconds", value);	
		}
		/** 
		Set the value of the AddYears input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddYears(Integer value) {
			this.setInput("AddYears", value);
		}

		/** 
		Set the value of the AddYears input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddYears(String value) {
			this.setInput("AddYears", value);	
		}
		/** 
		Set the value of the Granularity input for this Choreo. 

		@param String - (optional, string) Set to "seconds" to return the number of seconds since the epoch. Defaults to "milliseconds".
		*/
		public void set_Granularity(String value) {
			this.setInput("Granularity", value);
		}


		/** 
		Set the value of the SetDay input for this Choreo. 

		@param Integer - (optional, integer) Sets the day of month (1-31) of the specified date serial number.
		*/
		public void set_SetDay(Integer value) {
			this.setInput("SetDay", value);
		}

		/** 
		Set the value of the SetDay input for this Choreo as a String. 

		@param String - (optional, integer) Sets the day of month (1-31) of the specified date serial number.
		*/
		public void set_SetDay(String value) {
			this.setInput("SetDay", value);	
		}
		/** 
		Set the value of the SetHour input for this Choreo. 

		@param Integer - (optional, integer) Sets the hours (0-23) of the specified date serial number.
		*/
		public void set_SetHour(Integer value) {
			this.setInput("SetHour", value);
		}

		/** 
		Set the value of the SetHour input for this Choreo as a String. 

		@param String - (optional, integer) Sets the hours (0-23) of the specified date serial number.
		*/
		public void set_SetHour(String value) {
			this.setInput("SetHour", value);	
		}
		/** 
		Set the value of the SetMinute input for this Choreo. 

		@param Integer - (optional, integer) Sets the minutes (0-59) of the specified date serial number.
		*/
		public void set_SetMinute(Integer value) {
			this.setInput("SetMinute", value);
		}

		/** 
		Set the value of the SetMinute input for this Choreo as a String. 

		@param String - (optional, integer) Sets the minutes (0-59) of the specified date serial number.
		*/
		public void set_SetMinute(String value) {
			this.setInput("SetMinute", value);	
		}
		/** 
		Set the value of the SetMonth input for this Choreo. 

		@param Integer - (optional, integer) Sets the month (1-12) of the specified date serial number.
		*/
		public void set_SetMonth(Integer value) {
			this.setInput("SetMonth", value);
		}

		/** 
		Set the value of the SetMonth input for this Choreo as a String. 

		@param String - (optional, integer) Sets the month (1-12) of the specified date serial number.
		*/
		public void set_SetMonth(String value) {
			this.setInput("SetMonth", value);	
		}
		/** 
		Set the value of the SetSecond input for this Choreo. 

		@param Integer - (optional, integer) Sets the seconds (0-59) of the specified date serial number.
		*/
		public void set_SetSecond(Integer value) {
			this.setInput("SetSecond", value);
		}

		/** 
		Set the value of the SetSecond input for this Choreo as a String. 

		@param String - (optional, integer) Sets the seconds (0-59) of the specified date serial number.
		*/
		public void set_SetSecond(String value) {
			this.setInput("SetSecond", value);	
		}
		/** 
		Set the value of the SetYear input for this Choreo. 

		@param Integer - (optional, integer) Sets the year (such as 1989) of the specified date serial number.
		*/
		public void set_SetYear(Integer value) {
			this.setInput("SetYear", value);
		}

		/** 
		Set the value of the SetYear input for this Choreo as a String. 

		@param String - (optional, integer) Sets the year (such as 1989) of the specified date serial number.
		*/
		public void set_SetYear(String value) {
			this.setInput("SetYear", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTimestamp Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTimestampResultSet extends ResultSet {
		public GetTimestampResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Timestamp" output from this Choreo execution

		@return String - (date) A the current timestamp, expressed as the number of seconds or milliseconds since January 1, 1970 (epoch time). The Granularity input is used to indicate seconds or milliseconds.
		*/
		public String get_Timestamp() {
			return this.getResultString("Timestamp");
		}
	}
	
}
