package com.temboo.Library.Utilities.Dates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetDateDifference

Returns the difference between two specified dates, expressed as the number of milliseconds since January 1, 1970 (epoch time).
*/
public class GetDateDifference extends Choreography {

	/**
	Create a new instance of the GetDateDifference Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetDateDifference(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Dates/GetDateDifference"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetDateDifferenceInputSet
	*/
	public GetDateDifferenceInputSet newInputSet() {
		return new GetDateDifferenceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetDateDifferenceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetDateDifferenceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetDateDifference
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetDateDifferenceInputSet extends InputSet {
		/** 
		Set the value of the EarlierDate input for this Choreo. 

		@param String - (required, date) The earlier date to use for the date comparision (e.g., March 2, 2014).
		*/
		public void set_EarlierDate(String value) {
			this.setInput("EarlierDate", value);
		}


		/** 
		Set the value of the LaterDate input for this Choreo. 

		@param String - (required, date) The later date to use for the date comparision (e.g., March 3, 2014).
		*/
		public void set_LaterDate(String value) {
			this.setInput("LaterDate", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetDateDifference Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetDateDifferenceResultSet extends ResultSet {
		public GetDateDifferenceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Difference" output from this Choreo execution

		@return String - (integer) The difference between two specified dates, expressed as the number of milliseconds since January 1, 1970 (epoch time). 
		*/
		public String get_Difference() {
			return this.getResultString("Difference");
		}
	}
	
}
