package com.temboo.Library.Clicky;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TopStatsLastWeekByDay

Retrieves last weeks's top pages, links, and searches, by day.
*/
public class TopStatsLastWeekByDay extends Choreography {

	/**
	Create a new instance of the TopStatsLastWeekByDay Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TopStatsLastWeekByDay(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Clicky/TopStatsLastWeekByDay"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TopStatsLastWeekByDayInputSet
	*/
	public TopStatsLastWeekByDayInputSet newInputSet() {
		return new TopStatsLastWeekByDayInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TopStatsLastWeekByDayResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TopStatsLastWeekByDayResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TopStatsLastWeekByDay
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TopStatsLastWeekByDayInputSet extends InputSet {
		/** 
		Set the value of the Output input for this Choreo. 

		@param String - (optional, string) What format you want the returned data to be in. Accepted values: xml, php, json, csv. Defaults to 'xml'.
		*/
		public void set_Output(String value) {
			this.setInput("Output", value);
		}


		/** 
		Set the value of the SiteID input for this Choreo. 

		@param Integer - (required, integer) Your request must include the site's ID that you want to access data from. Available from your site preferences page.
		*/
		public void set_SiteID(Integer value) {
			this.setInput("SiteID", value);
		}

		/** 
		Set the value of the SiteID input for this Choreo as a String. 

		@param String - (required, integer) Your request must include the site's ID that you want to access data from. Available from your site preferences page.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);	
		}
		/** 
		Set the value of the SiteKey input for this Choreo. 

		@param String - (required, string) The unique key assigned to you when you first register with Clicky. Available from your site preferences page.
		*/
		public void set_SiteKey(String value) {
			this.setInput("SiteKey", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) The type of data you want to retrieve. Defaults to "pages,links,searches".
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TopStatsLastWeekByDay Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TopStatsLastWeekByDayResultSet extends ResultSet {
		public TopStatsLastWeekByDayResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Clicky formatted as specified in the Output parameter. Default is XML.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
