package com.temboo.Library.LinkedIn.Companies;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CompanyShare

Posts shared comment on a company page.
*/
public class CompanyShare extends Choreography {

	/**
	Create a new instance of the CompanyShare Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CompanyShare(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LinkedIn/Companies/CompanyShare"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CompanyShareInputSet
	*/
	public CompanyShareInputSet newInputSet() {
		return new CompanyShareInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CompanyShareResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CompanyShareResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CompanyShare
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CompanyShareInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by LinkedIn (AKA the Client ID).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the Comment input for this Choreo. 

		@param String - (conditional, string) A comment by the member to associated with the share. If this is not provided, you must specify the SubmittedURL.
		*/
		public void set_Comment(String value) {
			this.setInput("Comment", value);
		}


		/** 
		Set the value of the CompanyID input for this Choreo. 

		@param Integer - (required, integer) A LinkedIn assigned ID associated with the company.
		*/
		public void set_CompanyID(Integer value) {
			this.setInput("CompanyID", value);
		}

		/** 
		Set the value of the CompanyID input for this Choreo as a String. 

		@param String - (required, integer) A LinkedIn assigned ID associated with the company.
		*/
		public void set_CompanyID(String value) {
			this.setInput("CompanyID", value);	
		}
		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) The description of the content being shared.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SecretKey input for this Choreo. 

		@param String - (required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
		*/
		public void set_SecretKey(String value) {
			this.setInput("SecretKey", value);
		}


		/** 
		Set the value of the SharedTargetCode input for this Choreo. 

		@param String - (optional, string) A shared target code used to ensure that the shared content reaches a specific audience.
		*/
		public void set_SharedTargetCode(String value) {
			this.setInput("SharedTargetCode", value);
		}


		/** 
		Set the value of the SharedTargetValue input for this Choreo. 

		@param String - (optional, string) The name of the shared target used to ensure that the shared content reaches a specific audience.
		*/
		public void set_SharedTargetValue(String value) {
			this.setInput("SharedTargetValue", value);
		}


		/** 
		Set the value of the SubmittedImageURL input for this Choreo. 

		@param String - (optional, string) A fully qualified URL to a thumbnail image to accompany the shared content.
		*/
		public void set_SubmittedImageURL(String value) {
			this.setInput("SubmittedImageURL", value);
		}


		/** 
		Set the value of the SubmittedURL input for this Choreo. 

		@param String - (optional, string) A fully qualified URL for the content being shared.
		*/
		public void set_SubmittedURL(String value) {
			this.setInput("SubmittedURL", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) The title of the content being shared.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the Visibility input for this Choreo. 

		@param String - (required, string) The visibility setting of the share. Valid values are: anyone, connections-only.
		*/
		public void set_Visibility(String value) {
			this.setInput("Visibility", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CompanyShare Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CompanyShareResultSet extends ResultSet {
		public CompanyShareResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LinkedIn.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
