package com.temboo.Library.Wordnik.Word;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetHyphenation

Retrieves the hyphenation of a given word.
*/
public class GetHyphenation extends Choreography {

	/**
	Create a new instance of the GetHyphenation Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetHyphenation(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wordnik/Word/GetHyphenation"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetHyphenationInputSet
	*/
	public GetHyphenationInputSet newInputSet() {
		return new GetHyphenationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetHyphenationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetHyphenationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetHyphenation
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetHyphenationInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key from Wordnik.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Cannonical input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Cannonical(String value) {
			this.setInput("Cannonical", value);
		}


		/** 
		Set the value of the Dictionary input for this Choreo. 

		@param String - (optional, string) Source dictionary to return pronunciation from. Acceptable values: ahd, century, cmu, macmillan, wiktionary,webster, wordnet.
		*/
		public void set_Dictionary(String value) {
			this.setInput("Dictionary", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Maximum number of results to return. Defaults to 50.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Maximum number of results to return. Defaults to 50.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Response can be either JSON or XML. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the UseCanonical input for this Choreo. 

		@param Boolean - (optional, boolean) If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested. Defaults to false.
		*/
		public void set_UseCanonical(Boolean value) {
			this.setInput("UseCanonical", value);
		}

		/** 
		Set the value of the UseCanonical input for this Choreo as a String. 

		@param String - (optional, boolean) If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested. Defaults to false.
		*/
		public void set_UseCanonical(String value) {
			this.setInput("UseCanonical", value);	
		}
		/** 
		Set the value of the Word input for this Choreo. 

		@param String - (required, string) The word you want to look up on Wordnik.
		*/
		public void set_Word(String value) {
			this.setInput("Word", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetHyphenation Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetHyphenationResultSet extends ResultSet {
		public GetHyphenationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wordnik.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
