package com.temboo.Library.Google.Plus.Comments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
List

Retrieves a list all of the comments for a given activity.
*/
public class List extends Choreography {

	/**
	Create a new instance of the List Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public List(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Plus/Comments/List"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListInputSet
	*/
	public ListInputSet newInputSet() {
		return new ListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the List
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ActivityID input for this Choreo. 

		@param String - (required, string) The ID of the activity to get.
		*/
		public void set_ActivityID(String value) {
			this.setInput("ActivityID", value);
		}


		/** 
		Set the value of the Callback input for this Choreo. 

		@param String - (optional, string) Specifies a JavaScript function that will be passed the response data for using the API with JSONP.
		*/
		public void set_Callback(String value) {
			this.setInput("Callback", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See documentation for syntax rules.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of people to include in the response. Used for paging through results. Valid values are: 1 to 20. Default is 10.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of people to include in the response. Used for paging through results. Valid values are: 1 to 20. Default is 10.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the PageToken input for this Choreo. 

		@param String - (optional, string) The "NextPageToken" returned in the Choreo output. Used to page through large result sets.
		*/
		public void set_PageToken(String value) {
			this.setInput("PageToken", value);
		}


		/** 
		Set the value of the PrettyPrint input for this Choreo. 

		@param Boolean - (optional, boolean) A flag used to pretty print the json response to make it more readable. Defaults to "true".
		*/
		public void set_PrettyPrint(Boolean value) {
			this.setInput("PrettyPrint", value);
		}

		/** 
		Set the value of the PrettyPrint input for this Choreo as a String. 

		@param String - (optional, boolean) A flag used to pretty print the json response to make it more readable. Defaults to "true".
		*/
		public void set_PrettyPrint(String value) {
			this.setInput("PrettyPrint", value);	
		}
		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) The order in which to sort the list of comments. Valid values are: "ascending" (Sort oldest comments first, the default) and "descending" (Sort newest comments first).
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the UserIP input for this Choreo. 

		@param String - (optional, string) Identifies the IP address of the end user for whom the API call is being made. Used to enforce per-user quotas.
		*/
		public void set_UserIP(String value) {
			this.setInput("UserIP", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the List Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListResultSet extends ResultSet {
		public ListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
