package com.temboo.Library.Labs.GetWeather;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ByAddress

Retrieves weather and UV index data for a given Geo point using the Yahoo Weather and EnviroFacts APIs.
*/
public class ByAddress extends Choreography {

	/**
	Create a new instance of the ByAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ByAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Labs/GetWeather/ByAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ByAddressInputSet
	*/
	public ByAddressInputSet newInputSet() {
		return new ByAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ByAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ByAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ByAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ByAddressInputSet extends InputSet {
		/** 
		Set the value of the APICredentials input for this Choreo. 

		@param String - (optional, json) A JSON dictionary containing a Yahoo App ID. See Choreo documentation for formatting examples.
		*/
		public void set_APICredentials(String value) {
			this.setInput("APICredentials", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) The street address of the location to get weather for.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ByAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ByAddressResultSet extends ResultSet {
		public ByAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) Contains combined weather data from Yahoo Weather and EnviroFacts.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
