package com.temboo.Library.Dropbox.OAuth;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FromOAuth1

Creates an OAuth 2.0 access token from the supplied OAuth 1.0 access token.
*/
public class FromOAuth1 extends Choreography {

	/**
	Create a new instance of the FromOAuth1 Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FromOAuth1(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/OAuth/FromOAuth1"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FromOAuth1InputSet
	*/
	public FromOAuth1InputSet newInputSet() {
		return new FromOAuth1InputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FromOAuth1ResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FromOAuth1ResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FromOAuth1
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FromOAuth1InputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) An OAuth 1.0 access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) An OAuth 1.0 access token secret for a specific Dropbox user.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox after registering your application.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox after registering your application.
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FromOAuth1 Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FromOAuth1ResultSet extends ResultSet {
		public FromOAuth1ResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "OAuth2AccessToken" output from this Choreo execution

		@return String - (string) The OAuth 2.0 access for a specific Dropbox user.
		*/
		public String get_OAuth2AccessToken() {
			return this.getResultString("OAuth2AccessToken");
		}
	}
	
}
