package com.temboo.Library.Dropbox.FilesAndMetadata;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CommitChunkedUpload

Completes an upload initiated by the ChunkedUpload Choreo.
*/
public class CommitChunkedUpload extends Choreography {

	/**
	Create a new instance of the CommitChunkedUpload Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CommitChunkedUpload(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FilesAndMetadata/CommitChunkedUpload"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CommitChunkedUploadInputSet
	*/
	public CommitChunkedUploadInputSet newInputSet() {
		return new CommitChunkedUploadInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CommitChunkedUploadResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CommitChunkedUploadResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CommitChunkedUpload
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CommitChunkedUploadInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the Locale input for this Choreo. 

		@param String - (optional, string) The metadata returned on successful upload will have its size field translated based on the given locale.
		*/
		public void set_Locale(String value) {
			this.setInput("Locale", value);
		}


		/** 
		Set the value of the Overwrite input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates what happens when a file already exists at the specified path. If true (the default), the existing file will be overwritten. If false, the new file will be automatically renamed.
		*/
		public void set_Overwrite(Boolean value) {
			this.setInput("Overwrite", value);
		}

		/** 
		Set the value of the Overwrite input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates what happens when a file already exists at the specified path. If true (the default), the existing file will be overwritten. If false, the new file will be automatically renamed.
		*/
		public void set_Overwrite(String value) {
			this.setInput("Overwrite", value);	
		}
		/** 
		Set the value of the ParentRevision input for this Choreo. 

		@param String - (optional, string) The revision of the file you're editing. If this value matches the latest version of the file on the user's Dropbox, that file will be replaced, otherwise a new file will be created.
		*/
		public void set_ParentRevision(String value) {
			this.setInput("ParentRevision", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path to the file you want to write to (i.e. /RootFolder/SubFolder/MyFile.txt).
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Root input for this Choreo. 

		@param String - (optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).
		*/
		public void set_Root(String value) {
			this.setInput("Root", value);
		}


		/** 
		Set the value of the UploadID input for this Choreo. 

		@param String - (required, string) Used to identify the chunked upload session you'd like to commit. This is returned from the ChunkedUpload Choreo.
		*/
		public void set_UploadID(String value) {
			this.setInput("UploadID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CommitChunkedUpload Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CommitChunkedUploadResultSet extends ResultSet {
		public CommitChunkedUploadResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
