package com.temboo.Library.Dropbox.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetMetadata

Returns the metadata for a file or folder.
*/
public class GetMetadata extends Choreography {

	/**
	Create a new instance of the GetMetadata Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetMetadata(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Files/GetMetadata"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetMetadataInputSet
	*/
	public GetMetadataInputSet newInputSet() {
		return new GetMetadataInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetMetadataResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetMetadataResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetMetadata
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetMetadataInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the IncludeDeleted input for this Choreo. 

		@param Boolean - (optional, boolean) If true, DeletedMetadata will be returned for deleted file or folder, otherwise LookupError.not_found will be returned. The default for this field is false.
		*/
		public void set_IncludeDeleted(Boolean value) {
			this.setInput("IncludeDeleted", value);
		}

		/** 
		Set the value of the IncludeDeleted input for this Choreo as a String. 

		@param String - (optional, boolean) If true, DeletedMetadata will be returned for deleted file or folder, otherwise LookupError.not_found will be returned. The default for this field is false.
		*/
		public void set_IncludeDeleted(String value) {
			this.setInput("IncludeDeleted", value);	
		}
		/** 
		Set the value of the IncludeHasExplicitSharedMembers input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.
		*/
		public void set_IncludeHasExplicitSharedMembers(Boolean value) {
			this.setInput("IncludeHasExplicitSharedMembers", value);
		}

		/** 
		Set the value of the IncludeHasExplicitSharedMembers input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.
		*/
		public void set_IncludeHasExplicitSharedMembers(String value) {
			this.setInput("IncludeHasExplicitSharedMembers", value);	
		}
		/** 
		Set the value of the IncludeMediaInfo input for this Choreo. 

		@param Boolean - (optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.
		*/
		public void set_IncludeMediaInfo(Boolean value) {
			this.setInput("IncludeMediaInfo", value);
		}

		/** 
		Set the value of the IncludeMediaInfo input for this Choreo as a String. 

		@param String - (optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.
		*/
		public void set_IncludeMediaInfo(String value) {
			this.setInput("IncludeMediaInfo", value);	
		}
		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path of a file or folder on Dropbox.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetMetadata Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetMetadataResultSet extends ResultSet {
		public GetMetadataResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Dropbox.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
