package com.temboo.Library.LittleSis.List;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetList

Retrieves information about a List in LittleSis according to its ID.
*/
public class GetList extends Choreography {

	/**
	Create a new instance of the GetList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/List/GetList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetListInputSet
	*/
	public GetListInputSet newInputSet() {
		return new GetListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetListInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Entities input for this Choreo. 

		@param String - (optional, string) Indicate "entities" to retrieve records of the entities that belong to the list. Otherwise, only a basic record about the list will be returned.
		*/
		public void set_Entities(String value) {
			this.setInput("Entities", value);
		}


		/** 
		Set the value of the ListID input for this Choreo. 

		@param Integer - (required, integer) The ID of the list record to be returned.
		*/
		public void set_ListID(Integer value) {
			this.setInput("ListID", value);
		}

		/** 
		Set the value of the ListID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the list record to be returned.
		*/
		public void set_ListID(String value) {
			this.setInput("ListID", value);	
		}
		/** 
		Set the value of the Number input for this Choreo. 

		@param Integer - (optional, integer) Specifies what number of results to show. Used in conjunction with Page parameter, a Nnumber of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Number(Integer value) {
			this.setInput("Number", value);
		}

		/** 
		Set the value of the Number input for this Choreo as a String. 

		@param String - (optional, integer) Specifies what number of results to show. Used in conjunction with Page parameter, a Nnumber of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Number(String value) {
			this.setInput("Number", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Specifies what page of results to show. Used in conjunction with Number parameter. A number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Specifies what page of results to show. Used in conjunction with Number parameter. A number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TypeID input for this Choreo. 

		@param Integer - (optional, integer) When the Entities parameter is activated, you can specify type IDs limiting the entities returned to those having the specified types (as a comma-delimited list).
		*/
		public void set_TypeID(Integer value) {
			this.setInput("TypeID", value);
		}

		/** 
		Set the value of the TypeID input for this Choreo as a String. 

		@param String - (optional, integer) When the Entities parameter is activated, you can specify type IDs limiting the entities returned to those having the specified types (as a comma-delimited list).
		*/
		public void set_TypeID(String value) {
			this.setInput("TypeID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetListResultSet extends ResultSet {
		public GetListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
