package com.temboo.Library.LittleSis.Entity;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLeadershipByPerson

Retrieves a list of organizations of which a given person is an executive or board member.
*/
public class GetLeadershipByPerson extends Choreography {

	/**
	Create a new instance of the GetLeadershipByPerson Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLeadershipByPerson(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/Entity/GetLeadershipByPerson"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLeadershipByPersonInputSet
	*/
	public GetLeadershipByPersonInputSet newInputSet() {
		return new GetLeadershipByPersonInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLeadershipByPersonResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLeadershipByPersonResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLeadershipByPerson
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLeadershipByPersonInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Current input for this Choreo. 

		@param Integer - (optional, integer) Set to 1 to limit the relationships returned to only past relationships. Set to 0 to limit relationships returned to only current relationships. Defaults to all.
		*/
		public void set_Current(Integer value) {
			this.setInput("Current", value);
		}

		/** 
		Set the value of the Current input for this Choreo as a String. 

		@param String - (optional, integer) Set to 1 to limit the relationships returned to only past relationships. Set to 0 to limit relationships returned to only current relationships. Defaults to all.
		*/
		public void set_Current(String value) {
			this.setInput("Current", value);	
		}
		/** 
		Set the value of the EntityID input for this Choreo. 

		@param Integer - (required, integer) The ID of the person.
		*/
		public void set_EntityID(Integer value) {
			this.setInput("EntityID", value);
		}

		/** 
		Set the value of the EntityID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the person.
		*/
		public void set_EntityID(String value) {
			this.setInput("EntityID", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) Limits results to organizations of the specified type, e.g. "PublicCompany."
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLeadershipByPerson Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLeadershipByPersonResultSet extends ResultSet {
		public GetLeadershipByPersonResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
