package com.temboo.Library.Amazon.IAM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteSigningCertificate

Deletes the specified signing certificate associated with the specified user.
*/
public class DeleteSigningCertificate extends Choreography {

	/**
	Create a new instance of the DeleteSigningCertificate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteSigningCertificate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/IAM/DeleteSigningCertificate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteSigningCertificateInputSet
	*/
	public DeleteSigningCertificateInputSet newInputSet() {
		return new DeleteSigningCertificateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteSigningCertificateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteSigningCertificateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteSigningCertificate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteSigningCertificateInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the CertificateId input for this Choreo. 

		@param String - (required, string) ID of the signing certificate to delete.
		*/
		public void set_CertificateId(String value) {
			this.setInput("CertificateId", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserName input for this Choreo. 

		@param String - (optional, string) Name of the user the signing certificate belongs to.
		*/
		public void set_UserName(String value) {
			this.setInput("UserName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteSigningCertificate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteSigningCertificateResultSet extends ResultSet {
		public DeleteSigningCertificateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
