package com.temboo.Library.Facebook.Reading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Picture

Retrieves a person's profile picture.
*/
public class Picture extends Choreography {

	/**
	Create a new instance of the Picture Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Picture(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Reading/Picture"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PictureInputSet
	*/
	public PictureInputSet newInputSet() {
		return new PictureInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PictureResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PictureResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Picture
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PictureInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (conditional, string) The access token retrieved from the final step of the OAuth process. This is not required when providing a ProfileID.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Height input for this Choreo. 

		@param Integer - (optional, integer) Restricts the picture height to this size in pixels.
		*/
		public void set_Height(Integer value) {
			this.setInput("Height", value);
		}

		/** 
		Set the value of the Height input for this Choreo as a String. 

		@param String - (optional, integer) Restricts the picture height to this size in pixels.
		*/
		public void set_Height(String value) {
			this.setInput("Height", value);	
		}
		/** 
		Set the value of the ProfileID input for this Choreo. 

		@param String - (conditional, string) The id of the profile to retrieve a profile picture for. Defaults to "me" indicating the authenticated user.
		*/
		public void set_ProfileID(String value) {
			this.setInput("ProfileID", value);
		}


		/** 
		Set the value of the Redirect input for this Choreo. 

		@param Boolean - (optional, boolean) By default, the picture itself is returned as Base64 encoded data.and not a JSON. To return a JSON response, set Redirect to "false".
		*/
		public void set_Redirect(Boolean value) {
			this.setInput("Redirect", value);
		}

		/** 
		Set the value of the Redirect input for this Choreo as a String. 

		@param String - (optional, boolean) By default, the picture itself is returned as Base64 encoded data.and not a JSON. To return a JSON response, set Redirect to "false".
		*/
		public void set_Redirect(String value) {
			this.setInput("Redirect", value);	
		}
		/** 
		Set the value of the ReturnSSLResources input for this Choreo. 

		@param Boolean - (optional, boolean) Deprecated (retained for backward compatibility only).
		*/
		public void set_ReturnSSLResources(Boolean value) {
			this.setInput("ReturnSSLResources", value);
		}

		/** 
		Set the value of the ReturnSSLResources input for this Choreo as a String. 

		@param String - (optional, boolean) Deprecated (retained for backward compatibility only).
		*/
		public void set_ReturnSSLResources(String value) {
			this.setInput("ReturnSSLResources", value);	
		}
		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) The size of the image to retrieve. Valid values: square (50x50), small (50 pixels wide, variable height), normal (100 pixels wide, variable height), and large (about 200 pixels wide, variable height)
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the Width input for this Choreo. 

		@param Integer - (optional, integer) Restricts the picture width to this size in pixels. When Height and Width are both used, the image will be scaled as close to the dimensions as possible and then cropped down.
		*/
		public void set_Width(Integer value) {
			this.setInput("Width", value);
		}

		/** 
		Set the value of the Width input for this Choreo as a String. 

		@param String - (optional, integer) Restricts the picture width to this size in pixels. When Height and Width are both used, the image will be scaled as close to the dimensions as possible and then cropped down.
		*/
		public void set_Width(String value) {
			this.setInput("Width", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Picture Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PictureResultSet extends ResultSet {
		public PictureResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Contains the Base64 encoded value of the image retrieved from Facebook by default. When setting Redirect to "false", the response is a JSON string containing the image URL.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
