package com.temboo.Library.Facebook.Actions.Music.Playlists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdatePlaylist

Updates an existing playlist action.
*/
public class UpdatePlaylist extends Choreography {

	/**
	Create a new instance of the UpdatePlaylist Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdatePlaylist(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Actions/Music/Playlists/UpdatePlaylist"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdatePlaylistInputSet
	*/
	public UpdatePlaylistInputSet newInputSet() {
		return new UpdatePlaylistInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdatePlaylistResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdatePlaylistResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdatePlaylist
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdatePlaylistInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ActionID input for this Choreo. 

		@param String - (required, string) The id of the action to update.
		*/
		public void set_ActionID(String value) {
			this.setInput("ActionID", value);
		}


		/** 
		Set the value of the EndTime input for this Choreo. 

		@param String - (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
		*/
		public void set_EndTime(String value) {
			this.setInput("EndTime", value);
		}


		/** 
		Set the value of the ExpiresIn input for this Choreo. 

		@param Integer - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(Integer value) {
			this.setInput("ExpiresIn", value);
		}

		/** 
		Set the value of the ExpiresIn input for this Choreo as a String. 

		@param String - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(String value) {
			this.setInput("ExpiresIn", value);	
		}
		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Place input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
		*/
		public void set_Place(String value) {
			this.setInput("Place", value);
		}


		/** 
		Set the value of the PlayList input for this Choreo. 

		@param String - (optional, string) An object representing a playlist
		*/
		public void set_PlayList(String value) {
			this.setInput("PlayList", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) A comma separated list of other profile IDs that also performed this action.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdatePlaylist Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdatePlaylistResultSet extends ResultSet {
		public UpdatePlaylistResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
