package com.temboo.Library.Flickr.Photos;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchPhotos

Returns a list of photos matching a search criteria.
*/
public class SearchPhotos extends Choreography {

	/**
	Create a new instance of the SearchPhotos Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchPhotos(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Flickr/Photos/SearchPhotos"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchPhotosInputSet
	*/
	public SearchPhotosInputSet newInputSet() {
		return new SearchPhotosInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchPhotosResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchPhotosResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchPhotos
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchPhotosInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Flickr (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Accuracy input for this Choreo. 

		@param Integer - (optional, integer) The accuracy level of the location information. Current range is 1-16. World level is 1, Country is ~3, Region is ~6, City is ~11, Street is ~16.
		*/
		public void set_Accuracy(Integer value) {
			this.setInput("Accuracy", value);
		}

		/** 
		Set the value of the Accuracy input for this Choreo as a String. 

		@param String - (optional, integer) The accuracy level of the location information. Current range is 1-16. World level is 1, Country is ~3, Region is ~6, City is ~11, Street is ~16.
		*/
		public void set_Accuracy(String value) {
			this.setInput("Accuracy", value);	
		}
		/** 
		Set the value of the BoundingBox input for this Choreo. 

		@param String - (optional, string) A comma-delimited list of 4 values defining the Bounding Box of the area that will be searched. These values represent the coordinates of the bottom-left corner and top-right corner of the box.
		*/
		public void set_BoundingBox(String value) {
			this.setInput("BoundingBox", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param Integer - (optional, integer) The content type setting. 1 = photos only, 2 = screenshots only, 3 = other, 4 = photos and screenshots, 5 = screenshots and other, 6 = photos and other, 7 = all.
		*/
		public void set_ContentType(Integer value) {
			this.setInput("ContentType", value);
		}

		/** 
		Set the value of the ContentType input for this Choreo as a String. 

		@param String - (optional, integer) The content type setting. 1 = photos only, 2 = screenshots only, 3 = other, 4 = photos and screenshots, 5 = screenshots and other, 6 = photos and other, 7 = all.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);	
		}
		/** 
		Set the value of the Extras input for this Choreo. 

		@param String - (optional, string) A comma-delimited list of extra information to fetch for each returned record. See documentation for more details on supported fields.
		*/
		public void set_Extras(String value) {
			this.setInput("Extras", value);
		}


		/** 
		Set the value of the GeoContext input for this Choreo. 

		@param Integer - (optional, integer) A numeric value representing the photo's location info beyond latitude and longitude. 0 = not defined, 1 = indoors, 2 = outdoors.
		*/
		public void set_GeoContext(Integer value) {
			this.setInput("GeoContext", value);
		}

		/** 
		Set the value of the GeoContext input for this Choreo as a String. 

		@param String - (optional, integer) A numeric value representing the photo's location info beyond latitude and longitude. 0 = not defined, 1 = indoors, 2 = outdoors.
		*/
		public void set_GeoContext(String value) {
			this.setInput("GeoContext", value);	
		}
		/** 
		Set the value of the GroupID input for this Choreo. 

		@param String - (optional, string) The id of a group who's pool to search. If specified, only matching photos posted to the group's pool will be returned.
		*/
		public void set_GroupID(String value) {
			this.setInput("GroupID", value);
		}


		/** 
		Set the value of the InGallery input for this Choreo. 

		@param Boolean - (optional, boolean) Limits the search to only photos that are in a gallery. Default is false.
		*/
		public void set_InGallery(Boolean value) {
			this.setInput("InGallery", value);
		}

		/** 
		Set the value of the InGallery input for this Choreo as a String. 

		@param String - (optional, boolean) Limits the search to only photos that are in a gallery. Default is false.
		*/
		public void set_InGallery(String value) {
			this.setInput("InGallery", value);	
		}
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) A valid latitude, in decimal format, for performing geo queries (not required if providing another limiting search parameter).
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (conditional, decimal) A valid latitude, in decimal format, for performing geo queries (not required if providing another limiting search parameter).
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) A valid longitude, in decimal format, for performing geo queries (not required if providing another limiting search parameter).
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (conditional, decimal) A valid longitude, in decimal format, for performing geo queries (not required if providing another limiting search parameter).
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the MaxTakenDate input for this Choreo. 

		@param String - (optional, date) The maximum taken date. Photos with an taken date less than or equal to this value will be returned. The date can be in the form of a mysql datetime or unix timestamp.
		*/
		public void set_MaxTakenDate(String value) {
			this.setInput("MaxTakenDate", value);
		}


		/** 
		Set the value of the MaxUploadDate input for this Choreo. 

		@param String - (optional, date) The maximum upload date. Photos with an upload date less than or equal to this value will be returned. The date can be in the form of a unix timestamp or mysql datetime.
		*/
		public void set_MaxUploadDate(String value) {
			this.setInput("MaxUploadDate", value);
		}


		/** 
		Set the value of the Media input for this Choreo. 

		@param String - (optional, string) Filter results by media type. Valid values are all (default), photos or videos.
		*/
		public void set_Media(String value) {
			this.setInput("Media", value);
		}


		/** 
		Set the value of the MinTakenDate input for this Choreo. 

		@param String - (optional, date) The minimum taken date. Photos with a taken date greater than or equal to this value will be returned. The date can be in the form of a mysql datetime or unix timestamp.
		*/
		public void set_MinTakenDate(String value) {
			this.setInput("MinTakenDate", value);
		}


		/** 
		Set the value of the MinUploadDate input for this Choreo. 

		@param String - (optional, date) The minimum upload date. Photos with an upload date greater than or equal to this value will be returned. The date can be in the form of a unix timestamp or mysql datetime.
		*/
		public void set_MinUploadDate(String value) {
			this.setInput("MinUploadDate", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to return. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to return. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of photos to return per page. Defaults to 100.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of photos to return per page. Defaults to 100.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the PlaceID input for this Choreo. 

		@param String - (optional, string) A Flickr place id.
		*/
		public void set_PlaceID(String value) {
			this.setInput("PlaceID", value);
		}


		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (optional, integer) A valid radius used for geo queries, greater than zero and less than 20 miles (or 32 kilometers). Defaults to 5 (km).
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (optional, integer) A valid radius used for geo queries, greater than zero and less than 20 miles (or 32 kilometers). Defaults to 5 (km).
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
		/** 
		Set the value of the RadiusUnits input for this Choreo. 

		@param String - (optional, string) The unit of measure when doing radial geo queries. Valid values are: "mi" (miles) and "km" (kilometers). The default is "km".
		*/
		public void set_RadiusUnits(String value) {
			this.setInput("RadiusUnits", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml and json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Defaults to date-posted-desc unless performing a geo query. Valid values are: date-posted-asc, date-posted-desc, date-taken-asc, date-taken-desc, interestingness-desc, interestingness-asc, relevance.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the TagMode input for this Choreo. 

		@param String - (optional, string) Use the mode 'any' to search using an OR combination of tags. Use 'all' for an AND combnation. Defaults to 'any'.
		*/
		public void set_TagMode(String value) {
			this.setInput("TagMode", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) A comma-delimited list of tags. Photos with one or more of the tags listed will be returned. You can exclude results that match a term by prepending it with a hyphen.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (conditional, string) A keyword search against photo titles, descriptions, or tags. Prepend search term with a hyphen to exclude. Not required if providing another limiting search parameter.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The ID of the user who's photo to search. If this parameter isn't passed, all public photos will be searched. A value of "me" will search against the authenticated user's photos.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


		/** 
		Set the value of the WOEID input for this Choreo. 

		@param String - (optional, string) The unique 'Where on Earth ID' that uniquely represents spatial entities.
		*/
		public void set_WOEID(String value) {
			this.setInput("WOEID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchPhotos Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchPhotosResultSet extends ResultSet {
		public SearchPhotosResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Flickr.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
