package com.temboo.Library.Nexmo.Voice;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ConfirmTextToSpeechPrompt

Sends a Text-to-Speech message to the specifed Number and confirms the specifed pin-code.
*/
public class ConfirmTextToSpeechPrompt extends Choreography {

	/**
	Create a new instance of the ConfirmTextToSpeechPrompt Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ConfirmTextToSpeechPrompt(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Nexmo/Voice/ConfirmTextToSpeechPrompt"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ConfirmTextToSpeechPromptInputSet
	*/
	public ConfirmTextToSpeechPromptInputSet newInputSet() {
		return new ConfirmTextToSpeechPromptInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ConfirmTextToSpeechPromptResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ConfirmTextToSpeechPromptResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ConfirmTextToSpeechPrompt
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ConfirmTextToSpeechPromptInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your API Key provided to you by Nexmo.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your API Secret provided to you by Nexmo.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the ByeText input for this Choreo. 

		@param String - (required, string) Body of the text message played after digits are entered. (with a maximum length of 500 characters),
		*/
		public void set_ByeText(String value) {
			this.setInput("ByeText", value);
		}


		/** 
		Set the value of the CallbackMethod input for this Choreo. 

		@param String - (optional, string) The HTTP method for your callback. Valid values are: GET (default) or POST.
		*/
		public void set_CallbackMethod(String value) {
			this.setInput("CallbackMethod", value);
		}


		/** 
		Set the value of the CallbackURL input for this Choreo. 

		@param String - (required, string) A URL that Nexmo will request when the call ends to notify your application.
		*/
		public void set_CallbackURL(String value) {
			this.setInput("CallbackURL", value);
		}


		/** 
		Set the value of the DropIfMachine input for this Choreo. 

		@param Integer - (optional, integer) Deprecated (retained for backward compatibility only).
		*/
		public void set_DropIfMachine(Integer value) {
			this.setInput("DropIfMachine", value);
		}

		/** 
		Set the value of the DropIfMachine input for this Choreo as a String. 

		@param String - (optional, integer) Deprecated (retained for backward compatibility only).
		*/
		public void set_DropIfMachine(String value) {
			this.setInput("DropIfMachine", value);	
		}
		/** 
		Set the value of the FailedText input for this Choreo. 

		@param String - (required, string) Body of the text message played after 3 failed attempts. (with a maximum length of 500 characters),
		*/
		public void set_FailedText(String value) {
			this.setInput("FailedText", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (optional, string) A voice enabled inbound number associated with your Nexmo account.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) The language used to play back your message.  The default is "en-us" which corresponds to United States english.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the MachineDetection input for this Choreo. 

		@param String - (optional, string) If set to "hangup", the call will hang up immediately if a machine is detected, and the status in the CallbackData output will be set to "machine".
		*/
		public void set_MachineDetection(String value) {
			this.setInput("MachineDetection", value);
		}


		/** 
		Set the value of the MachineTimeout input for this Choreo. 

		@param Integer - (optional, integer) Time allocated to analyze if the call has been answered by a machine. The default value is 15000 (milliseconds).
		*/
		public void set_MachineTimeout(Integer value) {
			this.setInput("MachineTimeout", value);
		}

		/** 
		Set the value of the MachineTimeout input for this Choreo as a String. 

		@param String - (optional, integer) Time allocated to analyze if the call has been answered by a machine. The default value is 15000 (milliseconds).
		*/
		public void set_MachineTimeout(String value) {
			this.setInput("MachineTimeout", value);	
		}
		/** 
		Set the value of the MaxDigits input for this Choreo. 

		@param Integer - (required, integer) Number of digits entered by the end user.
		*/
		public void set_MaxDigits(Integer value) {
			this.setInput("MaxDigits", value);
		}

		/** 
		Set the value of the MaxDigits input for this Choreo as a String. 

		@param String - (required, integer) Number of digits entered by the end user.
		*/
		public void set_MaxDigits(String value) {
			this.setInput("MaxDigits", value);	
		}
		/** 
		Set the value of the PinCode input for this Choreo. 

		@param String - (required, string) Pin-code to be entered by end user (Pin-code length should be equals to MaxDigits).
		*/
		public void set_PinCode(String value) {
			this.setInput("PinCode", value);
		}


		/** 
		Set the value of the Repeat input for this Choreo. 

		@param Integer - (optional, integer) Define how many times you want to repeat the text message (default is 1 , maximum is 10).
		*/
		public void set_Repeat(Integer value) {
			this.setInput("Repeat", value);
		}

		/** 
		Set the value of the Repeat input for this Choreo as a String. 

		@param String - (optional, integer) Define how many times you want to repeat the text message (default is 1 , maximum is 10).
		*/
		public void set_Repeat(String value) {
			this.setInput("Repeat", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "json" (the default) and "xml".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (conditional, string) Body of the text message (with a maximum length of 1000 characters).
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) Phone number in international format and one recipient per request. (e.g. 447525856424 when sending to UK)
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


		/** 
		Set the value of the Voice input for this Choreo. 

		@param String - (optional, string) The voice to be used female (default) or male.
		*/
		public void set_Voice(String value) {
			this.setInput("Voice", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ConfirmTextToSpeechPrompt Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ConfirmTextToSpeechPromptResultSet extends ResultSet {
		public ConfirmTextToSpeechPromptResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Nexmo. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
