package com.temboo.Library.Nexmo.Account;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TopUp

Allows you to top-up your account provided that you've set up "auto-reload" in your Account Settings.
*/
public class TopUp extends Choreography {

	/**
	Create a new instance of the TopUp Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TopUp(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Nexmo/Account/TopUp"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TopUpInputSet
	*/
	public TopUpInputSet newInputSet() {
		return new TopUpInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TopUpResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TopUpResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TopUp
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TopUpInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your API Key provided to you by Nexmo.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your API Secret provided to you by Nexmo.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "json" (the default) and "xml".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TransactionID input for this Choreo. 

		@param String - (required, string) The transaction id associated with your **first** 'auto reload' top-up.
		*/
		public void set_TransactionID(String value) {
			this.setInput("TransactionID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TopUp Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TopUpResultSet extends ResultSet {
		public TopUpResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Nexmo. A 200 is returned for a successful request.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Nexmo. For a successful request, an empty response body is returned.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
